/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import collections.CircularList;
import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.UpdatableMap;
import collections.UpdatableSeq;
import de.renew.expression.LocalVariable;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.NameInterpreter;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedImportDecl;
import de.renew.formalism.java.Token;
import de.renew.util.ClassSource;
import de.renew.util.Types;

public class ParsedDeclarationNode
implements NameInterpreter {
    UpdatableSeq imports = new CircularList();
    UpdatableMap wellKnownClasses = new HashedMap();
    UpdatableMap variables = new HashedMap();
    private boolean anyVariablesDeclared = false;

    public void addImport(ParsedImportDecl parsedImportDecl, Token token) throws ParseException {
        if (parsedImportDecl.star) {
            this.imports.insertFirst(parsedImportDecl.name);
            return;
        }
        int n = parsedImportDecl.name.lastIndexOf(".");
        String string = parsedImportDecl.name.substring(n + 1);
        Object object = this.interpreteWellKnownName(string);
        if (object != null) {
            throw JavaHelper.makeParseException("Class " + string + " imported twice.", token);
        }
        this.wellKnownClasses.putAt(string, parsedImportDecl.name);
    }

    public void addVariable(Class clazz, String string, Token token) throws ParseException {
        Object object = this.interpreteWellKnownName(string);
        if (object != null) {
            if (object instanceof LocalVariable) {
                throw JavaHelper.makeParseException("Variable " + string + " declared twice.", token);
            }
            throw JavaHelper.makeParseException("Variable " + string + " is named identically to an imported class.", token);
        }
        this.variables.putAt(string, clazz);
        if (!"this".equals(string)) {
            this.anyVariablesDeclared = true;
        }
    }

    private static boolean classExists(String string) {
        try {
            ClassSource.classForName(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Class classForName(String string) {
        try {
            return ClassSource.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Could not load class.");
        }
    }

    public Object interpreteWellKnownName(String string) {
        if (this.variables.includesKey(string)) {
            return new LocalVariable(string);
        }
        if (this.wellKnownClasses.includesKey(string) && ParsedDeclarationNode.classExists((String)this.wellKnownClasses.at(string))) {
            return ParsedDeclarationNode.classForName((String)this.wellKnownClasses.at(string));
        }
        return null;
    }

    public Object interpreteName(String string) {
        if (string.indexOf(".") >= 0) {
            if (ParsedDeclarationNode.classExists(string)) {
                return ParsedDeclarationNode.classForName(string);
            }
            return null;
        }
        Object object = this.interpreteWellKnownName(string);
        if (object != null) {
            return object;
        }
        CollectionEnumeration collectionEnumeration = this.imports.elements();
        while (collectionEnumeration.hasMoreElements()) {
            String string2 = (String)collectionEnumeration.nextElement();
            if (!ParsedDeclarationNode.classExists(String.valueOf(string2) + "." + string)) continue;
            return ParsedDeclarationNode.classForName(String.valueOf(string2) + "." + string);
        }
        if (ParsedDeclarationNode.classExists(string)) {
            return ParsedDeclarationNode.classForName(string);
        }
        if (ParsedDeclarationNode.classExists("java.lang." + string)) {
            return ParsedDeclarationNode.classForName("java.lang." + string);
        }
        if (!this.anyVariablesDeclared) {
            return new LocalVariable(string);
        }
        return null;
    }

    public Class findType(LocalVariable localVariable) {
        if (this.variables.includesKey(localVariable.name)) {
            return (Class)this.variables.at(localVariable.name);
        }
        return Types.UNTYPED;
    }
}

