/*
 * Decompiled with CFR 0.152.
 */
package de.renew.function;

import de.renew.function.Executor;
import de.renew.function.Function;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.ReflectionSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class StaticMethodFunction
implements Function {
    transient Method method;

    public StaticMethodFunction(Method method) {
        if ((method.getModifiers() & 8) == 0) {
            throw new RuntimeException("Method expected to be static.");
        }
        this.method = method;
    }

    public Object function(Object object) throws Impossible {
        Tuple tuple = (Tuple)object;
        Object[] objectArray = new Object[tuple.getArity()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = tuple.getComponent(n);
            ++n;
        }
        try {
            return Executor.executeMethod(this.method, null, objectArray);
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                ((InvocationTargetException)exception).getTargetException().printStackTrace();
            }
            throw new Impossible("An exception occured during a method call.");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ReflectionSerializer.writeMethod(objectOutputStream, this.method);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.method = ReflectionSerializer.readMethod(objectInputStream);
    }
}

