/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.event.FiringEvent;
import de.renew.simulator.Binding;
import de.renew.simulator.ConsoleTracer;
import de.renew.simulator.SimulatorHelper;
import de.renew.simulator.TransitionInstance;
import de.renew.simulator.TriggerCollection;
import de.renew.simulator.Triggerable;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class BindingSelectionFrame
implements ActionListener,
ItemListener,
Triggerable {
    private static BindingSelectionFrame instance = null;
    private final Frame frame;
    private final TextArea currentElement;
    private final List bindingList;
    private final Button fireButton;
    private Binding[] binding;
    private TransitionInstance transitionInstance;
    private boolean dirty = false;
    private boolean inSearch = false;
    private boolean wantClose = false;
    private final TriggerCollection triggers = new TriggerCollection(this);

    static synchronized void open(TransitionInstance transitionInstance) {
        if (instance == null) {
            instance = new BindingSelectionFrame();
        }
        instance.setTransitionInstance(transitionInstance);
    }

    static synchronized void close() {
        if (instance != null) {
            instance.instanceClose();
        }
    }

    private BindingSelectionFrame() {
        this.frame = new Frame();
        this.currentElement = new TextArea(5, 50);
        this.currentElement.setEditable(false);
        this.frame.add((Component)this.currentElement, "North");
        this.bindingList = new List();
        this.bindingList.addActionListener(this);
        this.bindingList.addItemListener(this);
        this.frame.add((Component)this.bindingList, "Center");
        this.fireButton = new Button(" Fire ");
        this.fireButton.addActionListener(this);
        Button button = new Button(" Update ");
        button.addActionListener(new 1());
        Button button2 = new Button(" Close ");
        button2.addActionListener(new 2());
        Panel panel = new Panel();
        panel.add(this.fireButton);
        panel.add(button);
        panel.add(button2);
        this.frame.add((Component)panel, "South");
        this.frame.addWindowListener(new 3());
        this.frame.pack();
    }

    private synchronized void instanceClose() {
        if (this.inSearch) {
            this.wantClose = true;
            return;
        }
        this.closeNow();
    }

    private void closeNow() {
        this.triggers.clear();
        ((Component)this.frame).setVisible(false);
        this.bindingList.removeAll();
        this.transitionInstance = null;
        this.wantClose = false;
    }

    public TriggerCollection triggers() {
        return this.triggers;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        int n2 = itemEvent.getStateChange();
        String string = "";
        if (n2 == 1 && (n = this.bindingList.getSelectedIndex()) >= 0 && n < this.binding.length) {
            string = this.bindingList.getItem(n);
        }
        this.currentElement.setText(string);
        this.currentElement.setCaretPosition(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.bindingList.getSelectedIndex();
        if (n >= 0 && n < this.binding.length) {
            this.binding[n].execute(new ConsoleTracer("Synchronously", "(Manually) "), true);
            this.update();
            return;
        }
        this.fireButton.setEnabled(false);
    }

    private void setTransitionInstance(TransitionInstance transitionInstance) {
        this.transitionInstance = transitionInstance;
        this.wantClose = false;
        this.frame.setTitle(String.valueOf(transitionInstance) + "'s possible bindings");
        this.update();
    }

    public void firingStarted(FiringEvent firingEvent) {
        this.update();
    }

    public void firingComplete(FiringEvent firingEvent) {
        this.update();
    }

    public void proposeSearch(boolean bl, boolean bl2) {
        this.update();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update() {
        Object object = this;
        synchronized (object) {
            if (this.inSearch) {
                this.dirty = true;
                return;
            }
            if (this.wantClose) {
                this.closeNow();
                return;
            }
            this.dirty = false;
            this.inSearch = true;
        }
        while (true) {
            object = SimulatorHelper.findAllBindings(this.transitionInstance, this);
            int n = object.numberOfRemainingElements();
            this.binding = new Binding[n];
            this.bindingList.removeAll();
            int n2 = 0;
            while (true) {
                if (!object.hasMoreElements()) {
                    String string = "";
                    if (n > 0) {
                        this.bindingList.select(0);
                        string = this.bindingList.getItem(0);
                    }
                    this.currentElement.setText(string);
                    this.currentElement.setCaretPosition(0);
                }
                this.binding[n2] = (Binding)object.nextElement();
                this.bindingList.add(this.binding[n2].toString());
                ++n2;
            }
            this.fireButton.setEnabled(n != 0);
            ((Component)this.frame).setVisible(true);
            BindingSelectionFrame bindingSelectionFrame = this;
            synchronized (bindingSelectionFrame) {
                if (this.wantClose) {
                    this.closeNow();
                    this.dirty = false;
                }
                if (!this.dirty) {
                    this.inSearch = false;
                    return;
                }
                this.dirty = false;
            }
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BindingSelectionFrame.this.update();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BindingSelectionFrame.close();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)BindingSelectionFrame.this.frame).setVisible(false);
        }

        /* synthetic */ 3() {
        }
    }
}

