/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.DrawingViewFrame;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.SelectCommand;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.MessageDialog;
import CH.ifa.draw.util.StorableInput;
import de.renew.gui.AnimateCommand;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingView;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSelectionTool;
import de.renew.gui.CPNSimulation;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.CPNTextTool;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.FigureException;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.InstanceFigure;
import de.renew.gui.JavaMode;
import de.renew.gui.PatchingStorableInput;
import de.renew.gui.PlaceFigureCreationTool;
import de.renew.gui.RenewMode;
import de.renew.gui.ShadowNetSystemRenderer;
import de.renew.gui.SyntaxExceptionFrame;
import de.renew.gui.TokenBagDrawing;
import de.renew.gui.TransitionFigureCreationTool;
import de.renew.gui.TransitionInstanceFigure;
import de.renew.gui.VirtualPlaceFigureCreationTool;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import de.renew.simulator.Net;
import de.renew.simulator.NetInstance;
import de.renew.simulator.Place;
import de.renew.simulator.PlaceInstance;
import de.renew.simulator.Transition;
import de.renew.simulator.TransitionInstance;
import de.renew.util.PostscriptWriter;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import de.renew.util.StringUtil;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class CPNApplication
extends DrawApplication {
    public static final String CPNIMAGES = "/de/renew/gui/images/";
    private static final Color INSTANCE_COLOR = new Color(200, 200, 255);
    private static final Color TOKEN_BAG_COLOR = new Color(230, 230, 255);
    private ToolButton fInscrTB;
    private ToolButton fNameTB;
    private ToolButton fDeclTB;
    private ToolButton fConnTextTB;
    private ToolButton fTextTB;
    protected RenewMode fMode;
    private CPNSimulation fSimulation;
    private static final String RENEW_VERSION = "1.2";
    private SyntaxExceptionFrame syntaxFrame;
    static /* synthetic */ Class class$de$renew$gui$NodeFigure;
    static /* synthetic */ Class class$de$renew$gui$TransitionFigure;
    static /* synthetic */ Class class$de$renew$gui$PlaceFigure;
    static /* synthetic */ Class class$de$renew$gui$ArcConnection;
    static /* synthetic */ Class class$de$renew$gui$InscribableFigure;
    static /* synthetic */ Class class$de$renew$gui$CPNTextFigure;
    static /* synthetic */ Class class$de$renew$gui$CPNInstanceDrawing;
    static /* synthetic */ Class class$de$renew$simulator$Net;
    static /* synthetic */ Class class$de$renew$simulator$SearchQueue;

    public static String getVersion() {
        return RENEW_VERSION;
    }

    protected CPNApplication() {
        this(new String[0]);
    }

    protected CPNApplication(String[] stringArray) {
        super("Reference Net Workshop", "rnw", stringArray, "/de/renew/gui/images/RENEW.gif");
    }

    public RenewMode getMode() {
        if (this.fMode == null) {
            String string = System.getProperty("de.renew.mode");
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    this.fMode = (RenewMode)clazz.newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Switch failed:" + exception);
                }
            }
            if (this.fMode == null) {
                System.err.println("Using default mode...");
                this.fMode = new JavaMode();
            } else {
                System.err.println("Using mode " + string + "...");
            }
            if (this.fMode == null) {
                throw new RuntimeException("Could not initialize default mode.");
            }
            this.fSimulation = this.fMode.getSimulation();
        }
        return this.fMode;
    }

    protected Drawing createDrawing() {
        return new CPNDrawing();
    }

    protected DrawApplication newWindow() {
        return new CPNApplication();
    }

    protected void createMenus(MenuBar menuBar) {
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createAlignmentMenu());
        menuBar.add(this.createAttributesMenu());
        menuBar.add(this.createSimulationMenu());
        menuBar.add(this.createDrawingsMenu());
        this.getMode().createAdditionalMenus(this, menuBar);
    }

    protected SelectCommand createSelectCommand(String string, Class clazz, int n, int n2) {
        return new SelectCommand(string, (DrawingEditor)this, new 1(clazz, n), n2);
    }

    protected Menu createEditMenu() {
        Menu menu = super.createEditMenu();
        Menu menu2 = this.createSelectMenu(0);
        Menu menu3 = this.createSelectMenu(1);
        Menu menu4 = this.createSelectMenu(2);
        Menu menu5 = this.createSelectMenu(3);
        menu.insert(menu2, 11);
        menu.insert(menu3, 12);
        menu.insert(menu4, 13);
        menu.insert(menu5, 14);
        return menu;
    }

    protected Menu createSelectMenu(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "Select";
                break;
            }
            case 1: {
                string = "Add To Selection";
                break;
            }
            case 2: {
                string = "Remove From Selection";
                break;
            }
            case 3: {
                string = "Restrict Selection";
                break;
            }
            default: {
                string = "??? Select mode " + n + " ???";
            }
        }
        CommandMenu commandMenu = this.createCommandMenu(string);
        CommandMenu commandMenu2 = this.createCommandMenu("Nodes");
        commandMenu2.add(new SelectCommand("All", (DrawingEditor)this, class$de$renew$gui$NodeFigure != null ? class$de$renew$gui$NodeFigure : (class$de$renew$gui$NodeFigure = CPNApplication.class$("de.renew.gui.NodeFigure")), n));
        commandMenu2.add(new SelectCommand("Transitions", (DrawingEditor)this, class$de$renew$gui$TransitionFigure != null ? class$de$renew$gui$TransitionFigure : (class$de$renew$gui$TransitionFigure = CPNApplication.class$("de.renew.gui.TransitionFigure")), n));
        commandMenu2.add(new SelectCommand("Places", (DrawingEditor)this, class$de$renew$gui$PlaceFigure != null ? class$de$renew$gui$PlaceFigure : (class$de$renew$gui$PlaceFigure = CPNApplication.class$("de.renew.gui.PlaceFigure")), n));
        commandMenu.add(commandMenu2);
        commandMenu.add(new SelectCommand("Arcs", (DrawingEditor)this, class$de$renew$gui$ArcConnection != null ? class$de$renew$gui$ArcConnection : (class$de$renew$gui$ArcConnection = CPNApplication.class$("de.renew.gui.ArcConnection")), n));
        commandMenu.add(new SelectCommand("Nodes and Arcs", (DrawingEditor)this, class$de$renew$gui$InscribableFigure != null ? class$de$renew$gui$InscribableFigure : (class$de$renew$gui$InscribableFigure = CPNApplication.class$("de.renew.gui.InscribableFigure")), n));
        CommandMenu commandMenu3 = this.createCommandMenu("Text Children");
        commandMenu3.add(new SelectCommand("All", this, class$de$renew$gui$CPNTextFigure != null ? class$de$renew$gui$CPNTextFigure : (class$de$renew$gui$CPNTextFigure = CPNApplication.class$("de.renew.gui.CPNTextFigure")), class$de$renew$gui$InscribableFigure != null ? class$de$renew$gui$InscribableFigure : (class$de$renew$gui$InscribableFigure = CPNApplication.class$("de.renew.gui.InscribableFigure")), n));
        commandMenu3.add(new SelectCommand("of Transitions", this, class$de$renew$gui$CPNTextFigure != null ? class$de$renew$gui$CPNTextFigure : (class$de$renew$gui$CPNTextFigure = CPNApplication.class$("de.renew.gui.CPNTextFigure")), class$de$renew$gui$TransitionFigure != null ? class$de$renew$gui$TransitionFigure : (class$de$renew$gui$TransitionFigure = CPNApplication.class$("de.renew.gui.TransitionFigure")), n));
        commandMenu3.add(new SelectCommand("of Places", this, class$de$renew$gui$CPNTextFigure != null ? class$de$renew$gui$CPNTextFigure : (class$de$renew$gui$CPNTextFigure = CPNApplication.class$("de.renew.gui.CPNTextFigure")), class$de$renew$gui$PlaceFigure != null ? class$de$renew$gui$PlaceFigure : (class$de$renew$gui$PlaceFigure = CPNApplication.class$("de.renew.gui.PlaceFigure")), n));
        commandMenu3.add(new SelectCommand("of Arcs", this, class$de$renew$gui$CPNTextFigure != null ? class$de$renew$gui$CPNTextFigure : (class$de$renew$gui$CPNTextFigure = CPNApplication.class$("de.renew.gui.CPNTextFigure")), class$de$renew$gui$ArcConnection != null ? class$de$renew$gui$ArcConnection : (class$de$renew$gui$ArcConnection = CPNApplication.class$("de.renew.gui.ArcConnection")), n));
        commandMenu.add(commandMenu3);
        CommandMenu commandMenu4 = this.createCommandMenu("Inscriptions");
        commandMenu4.add(this.createSelectCommand("All", class$de$renew$gui$InscribableFigure != null ? class$de$renew$gui$InscribableFigure : (class$de$renew$gui$InscribableFigure = CPNApplication.class$("de.renew.gui.InscribableFigure")), 1, n));
        commandMenu4.add(this.createSelectCommand("of Transitions", class$de$renew$gui$TransitionFigure != null ? class$de$renew$gui$TransitionFigure : (class$de$renew$gui$TransitionFigure = CPNApplication.class$("de.renew.gui.TransitionFigure")), 1, n));
        commandMenu4.add(this.createSelectCommand("of Places", class$de$renew$gui$PlaceFigure != null ? class$de$renew$gui$PlaceFigure : (class$de$renew$gui$PlaceFigure = CPNApplication.class$("de.renew.gui.PlaceFigure")), 1, n));
        commandMenu4.add(this.createSelectCommand("of Arcs", class$de$renew$gui$ArcConnection != null ? class$de$renew$gui$ArcConnection : (class$de$renew$gui$ArcConnection = CPNApplication.class$("de.renew.gui.ArcConnection")), 1, n));
        commandMenu.add(commandMenu4);
        CommandMenu commandMenu5 = this.createCommandMenu("Names");
        commandMenu5.add(this.createSelectCommand("All", class$de$renew$gui$InscribableFigure != null ? class$de$renew$gui$InscribableFigure : (class$de$renew$gui$InscribableFigure = CPNApplication.class$("de.renew.gui.InscribableFigure")), 2, n));
        commandMenu5.add(this.createSelectCommand("of Transitions", class$de$renew$gui$TransitionFigure != null ? class$de$renew$gui$TransitionFigure : (class$de$renew$gui$TransitionFigure = CPNApplication.class$("de.renew.gui.TransitionFigure")), 2, n));
        commandMenu5.add(this.createSelectCommand("of Places", class$de$renew$gui$PlaceFigure != null ? class$de$renew$gui$PlaceFigure : (class$de$renew$gui$PlaceFigure = CPNApplication.class$("de.renew.gui.PlaceFigure")), 2, n));
        commandMenu.add(commandMenu5);
        return commandMenu;
    }

    protected Menu createAlignmentMenu() {
        CommandMenu commandMenu = (CommandMenu)super.createAlignmentMenu();
        commandMenu.addSeparator();
        commandMenu.add(new AnimateCommand("Toggle Automatic Net Layout", this));
        CommandMenu commandMenu2 = this.createCommandMenu("Location");
        commandMenu2.add(new ChangeAttributeCommand("dynamic", "Location", Boolean.FALSE, this));
        commandMenu2.add(new ChangeAttributeCommand("fixed", "Location", Boolean.TRUE, this));
        commandMenu.add(commandMenu2);
        return commandMenu;
    }

    protected Menu createSimulationMenu() {
        Menu menu = this.createMenu("Simulation");
        menu.add(this.createMenuItem("Run simulation", new MenuShortcut(82), new 2()));
        menu.add(this.createMenuItem("Simulation Step", new MenuShortcut(73), new 3()));
        menu.add(this.createMenuItem("Halt simulation", new MenuShortcut(72), new 5()));
        menu.add(this.createMenuItem("Terminate simulation", new MenuShortcut(84), new 6()));
        menu.addSeparator();
        menu.add(this.createMenuItem("Save simulation state...", new 7()));
        menu.add(this.createMenuItem("Load simulation state...", new 8()));
        menu.addSeparator();
        menu.add(this.createMenuItem("Syntax check only", new 9()));
        String[] stringArray = this.getMode().getCompiler().getLintNames();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = n;
            String string = stringArray[n];
            String string2 = StringUtil.firstToUpperCase(string);
            menu.add(this.createMenuItem(string2, new 10(n2, string, this, string2)));
            ++n;
        }
        menu.addSeparator();
        menu.add(this.createMenuItem("Associate Highlight", new 11()));
        menu.add(this.createMenuItem("Select Highlight(s)", new 12()));
        menu.add(this.createMenuItem("Unassociate Highlight", new 13()));
        return menu;
    }

    private void closeAllSimulationDrawings() {
        boolean bl;
        block0: do {
            bl = false;
            Enumeration enumeration = this.drawings();
            while (enumeration.hasMoreElements()) {
                Drawing drawing = (Drawing)enumeration.nextElement();
                if (!(drawing instanceof CPNInstanceDrawing) && !(drawing instanceof TokenBagDrawing)) continue;
                this.closeDrawing(drawing);
                bl = true;
                continue block0;
            }
        } while (bl);
    }

    protected StandardDrawingView createDrawingView(int n, int n2) {
        return new CPNDrawingView(this, n, n2);
    }

    protected Menu createFileMenu() {
        Menu menu = super.createFileMenu();
        menu.insert(this.createMenuItem("Set Selection as Icon", new 14()), menu.getItemCount() - 4);
        menu.insert(this.createMenuItem("Export PostScript...", new 15()), menu.getItemCount() - 2);
        menu.insert(this.createMenuItem("Export EPS...", new MenuShortcut(69), new 16()), menu.getItemCount() - 2);
        menu.insert(this.createMenuItem("Export to Macao...", new 17()), menu.getItemCount() - 2);
        menu.insert(this.createMenuItem("Export to Woflan...", new 18()), menu.getItemCount() - 2);
        menu.insert(this.createMenuItem("Export Shadow Net System...", new 19()), menu.getItemCount() - 2);
        menu.insert(this.createMenuItem("Import Shadow Net System...", new 20()), menu.getItemCount() - 2);
        return menu;
    }

    protected Menu createAttributesMenu() {
        Menu menu = super.createAttributesMenu();
        CommandMenu commandMenu = this.createCommandMenu("TextType");
        commandMenu.add(new ChangeAttributeCommand("Label", "TextType", new Integer(0), this));
        commandMenu.add(new ChangeAttributeCommand("Inscription", "TextType", new Integer(1), this));
        commandMenu.add(new ChangeAttributeCommand("Name", "TextType", new Integer(2), this));
        menu.add(commandMenu);
        menu.addSeparator();
        CommandMenu commandMenu2 = this.createCommandMenu("Trace");
        commandMenu2.add(new ChangeAttributeCommand("on", "TraceMode", Boolean.TRUE, this));
        commandMenu2.add(new ChangeAttributeCommand("off", "TraceMode", Boolean.FALSE, this));
        menu.add(commandMenu2);
        CommandMenu commandMenu3 = this.createCommandMenu("Marking");
        commandMenu3.add(new ChangeAttributeCommand("highlight only", "MarkingAppearance", new Integer(0), this));
        commandMenu3.add(new ChangeAttributeCommand("Cardinality", "MarkingAppearance", new Integer(1), this));
        commandMenu3.add(new ChangeAttributeCommand("expanded", "MarkingAppearance", new Integer(2), this));
        menu.add(commandMenu3);
        return menu;
    }

    protected void drawingAdded(Drawing drawing) {
        super.drawingAdded(drawing);
        if (drawing instanceof CPNDrawing) {
            this.fSimulation.addDrawing((CPNDrawing)drawing);
        }
    }

    protected void drawingReleased(Drawing drawing) {
        super.drawingReleased(drawing);
        if (drawing instanceof CPNDrawing) {
            this.fSimulation.releaseDrawing((CPNDrawing)drawing);
        }
    }

    private boolean syntaxCheck() {
        if (this.fSimulation.isSimulationActive()) {
            this.showStatus("Terminate the current simulation before a syntax check.");
        } else {
            try {
                this.fSimulation.syntaxCheckOnly();
                this.showStatus("Syntax check successful.");
                this.closeSyntaxErrorFrame();
                return true;
            }
            catch (SyntaxException syntaxException) {
                this.processSyntaxException(new FigureException(syntaxException), true);
            }
        }
        return false;
    }

    public void closeSyntaxErrorFrame() {
        if (this.syntaxFrame != null) {
            this.syntaxFrame.dispose();
            this.syntaxFrame = null;
        }
    }

    void processSyntaxException(FigureException figureException, boolean bl) {
        this.processFigureException(figureException, bl);
        this.showStatus("A syntax error occurred.");
    }

    void processFigureException(FigureException figureException, boolean bl) {
        if (this.syntaxFrame == null) {
            this.syntaxFrame = new SyntaxExceptionFrame(this);
        }
        this.syntaxFrame.displayException(figureException, bl);
    }

    boolean selectOffendingElements(FigureException figureException) {
        if (figureException.errorDrawing != null && !figureException.errorFigures.isEmpty()) {
            this.view().clearSelection();
            this.showDrawingViewFrame(figureException.errorDrawing);
            FigureEnumerator figureEnumerator = new FigureEnumerator(figureException.errorFigures);
            while (figureEnumerator.hasMoreElements()) {
                this.view().addToSelection(figureEnumerator.nextFigure());
            }
            this.view().repairDamage();
            if (figureException.textErrorFigure != null) {
                this.doTextEdit(figureException.textErrorFigure, figureException.line, figureException.column);
            }
            return true;
        }
        return false;
    }

    public void openInstanceDrawing(NetInstance netInstance) {
        CPNInstanceDrawing cPNInstanceDrawing = CPNInstanceDrawing.getInstanceDrawing(this.getMode(), netInstance);
        if (cPNInstanceDrawing != null) {
            boolean bl = this.getViewFrame(cPNInstanceDrawing) == null;
            DrawingViewFrame drawingViewFrame = this.showDrawingViewFrame(cPNInstanceDrawing);
            if (bl) {
                CPNDrawing cPNDrawing = this.fSimulation.getDrawing(netInstance.getNet().toString());
                DrawingViewFrame drawingViewFrame2 = this.getViewFrame(cPNDrawing);
                ((Component)drawingViewFrame).setLocation(drawingViewFrame2.getLocation());
                ((Component)drawingViewFrame).setSize(drawingViewFrame2.getSize());
                drawingViewFrame.onDiscardRelease();
                drawingViewFrame.view().setBackground(INSTANCE_COLOR);
                drawingViewFrame.validate();
            }
        }
    }

    public void openTokenBagDrawing(PlaceInstance placeInstance) {
        TokenBagDrawing tokenBagDrawing = TokenBagDrawing.getTokenBagDrawing(this.getMode(), placeInstance);
        boolean bl = this.getViewFrame(tokenBagDrawing) == null;
        DrawingViewFrame drawingViewFrame = this.showDrawingViewFrame(tokenBagDrawing);
        if (bl) {
            CPNInstanceDrawing cPNInstanceDrawing = CPNInstanceDrawing.getInstanceDrawing(this.getMode(), placeInstance.getNetInstance());
            DrawingViewFrame drawingViewFrame2 = this.getViewFrame(cPNInstanceDrawing);
            ((Component)drawingViewFrame).setLocation(drawingViewFrame2.getLocation());
            drawingViewFrame.onDiscardRelease();
            drawingViewFrame.view().setBackground(TOKEN_BAG_COLOR);
        }
    }

    void initSimulation() {
        if (!(this.drawing() instanceof CPNDrawing)) {
            this.showStatus("Cannot start new simulation with this drawing! Please activate a net window.");
            return;
        }
        try {
            NetInstance netInstance = this.fSimulation.initSimulation(this.drawing().getName(), this);
            if (netInstance != null) {
                this.openInstanceDrawing(netInstance);
                if (this.fSimulation.isSimulationActive()) {
                    this.showStatus("Simulation initialized.");
                    return;
                }
                this.showStatus("Simulation initialized. No enabled bindings.");
                return;
            }
            this.showStatus("The simulation could not be initialized.");
            return;
        }
        catch (SyntaxException syntaxException) {
            this.processSyntaxException(new FigureException(syntaxException), true);
            return;
        }
    }

    public void promptExportPostscript() {
        this.toolDone();
        String string = this.getSavePath("Export PostScript...", String.valueOf(this.drawing().getName()) + ".ps", new String[]{"ps"});
        if (string != null) {
            this.exportPostscript(string, false);
        }
    }

    public void promptExportEPS() {
        this.toolDone();
        String string = this.getSavePath("Export EPS...", String.valueOf(this.drawing().getName()) + ".eps", new String[]{"eps"});
        if (string != null) {
            this.exportPostscript(string, true);
        }
    }

    public void promptExportMacao() {
        if (this.drawing() instanceof CPNDrawing) {
            this.toolDone();
            String string = this.getSavePath("Export to Macao...", this.drawing().getName(), null);
            if (string != null) {
                try {
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
                    ((CPNDrawing)this.drawing()).exportMacao(printWriter);
                    printWriter.close();
                    return;
                }
                catch (Exception exception) {
                    this.showStatus(exception.toString());
                    return;
                }
            }
        } else {
            this.showStatus("This drawing is not a net!");
        }
    }

    public void promptExportWoflan() {
        if (this.drawing() instanceof CPNDrawing) {
            this.toolDone();
            String string = this.getSavePath("Export to Woflan...", this.drawing().getName(), null);
            if (string != null) {
                this.fSimulation.buildAllShadows();
                try {
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
                    ((CPNDrawing)this.drawing()).exportWoflan(printWriter);
                    printWriter.close();
                    return;
                }
                catch (Exception exception) {
                    this.showStatus(exception.toString());
                    return;
                }
            }
        } else {
            this.showStatus("This drawing is not a net!");
        }
    }

    public synchronized void loadAndOpenDrawing(String string) {
        if ("sns".equals(StringUtil.getExtension(string))) {
            this.importShadow(string);
            return;
        }
        super.loadAndOpenDrawing(string);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean closeViewFrame(DrawingViewFrame var1_1) {
        block1: {
            var2_2 = var1_1.view().drawing();
            if (!(var2_2 instanceof CPNDrawing) || (var3_3 = CPNInstanceDrawing.getDependentInstanceDrawings((CPNDrawing)var2_2)) == null) break block1;
            var4_4 = MessageDialog.invokeDialog(this.menuFrame(), "Renew: Confirm Close", new String[]{"The drawing \"" + var2_2.getName() + "\" " + "you are about to close", "is needed to display one or more instance drawings."}, 0, new String[]{" Close instance drawings ", " Cancel "});
            if (var4_4 != 1) ** GOTO lbl8
            return false;
lbl-1000:
            // 1 sources

            {
                this.closeDrawing((CPNInstanceDrawing)var3_3.nextElement());
lbl8:
                // 2 sources

                ** while (var3_3.hasMoreElements())
            }
        }
        return super.closeViewFrame(var1_1);
    }

    public void exit() {
        this.closeAllSimulationDrawings();
        super.exit();
    }

    public void promptImportShadow() {
        String string = this.getLoadPath("Open File...", null, new String[]{"sns", "sha"});
        if (string != null) {
            this.importShadow(string);
        }
    }

    private void importShadow(String string) {
        CPNDrawing[] cPNDrawingArray = ShadowNetSystemRenderer.render(string);
        int n = 0;
        while (n < cPNDrawingArray.length) {
            this.newDrawingViewFrame(cPNDrawingArray[n]);
            ++n;
        }
    }

    public void promptExportShadow() {
        String string;
        this.toolDone();
        if (this.syntaxCheck() && (string = this.getSavePath("Export all to Shadow Simulator...", null, new String[]{"sns", "sha"})) != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.fSimulation.getNetSystem());
                objectOutputStream.close();
                return;
            }
            catch (Exception exception) {
                this.showStatus(exception.toString());
                return;
            }
        }
    }

    private void exportPostscript(String string, boolean bl) {
        try {
            PostscriptWriter postscriptWriter = null;
            Dimension dimension = this.getDrawingViewSize();
            Rectangle rectangle = ((Figure)((Object)this.drawing())).displayBox();
            if (bl) {
                postscriptWriter = new PostscriptWriter(string, rectangle);
            } else {
                postscriptWriter = new PostscriptWriter(string);
                postscriptWriter.translate(32, 32 + dimension.height);
                dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
                dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
                postscriptWriter.setClip(0, 0, dimension.width, dimension.height);
                double d = Math.min(535.0 / (double)dimension.width, 778.0 / (double)dimension.height);
                if (d < 1.0) {
                    System.out.println("Scaling PS output by " + d);
                    postscriptWriter.scale(d, d);
                }
            }
            postscriptWriter.setColorConversion(ColorMap.BACKGROUND, Color.white);
            this.drawing().draw(postscriptWriter);
            postscriptWriter.dispose();
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            this.showStatus(iOException.toString());
            return;
        }
    }

    private void promptSaveSimulationState() {
        if (!this.fSimulation.isSimulationActive()) {
            this.showStatus("Need running simulation to save state.");
            return;
        }
        String string = this.getSavePath("Save Simulation State...", null, new String[]{"rst"});
        if (string != null) {
            Stack stack;
            String string2;
            block11: {
                string2 = null;
                stack = null;
                RenewObjectOutputStream renewObjectOutputStream = null;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    renewObjectOutputStream = new RenewObjectOutputStream(fileOutputStream);
                    this.fSimulation.saveState(renewObjectOutputStream);
                }
                catch (NotSerializableException notSerializableException) {
                    string2 = "Some object or class is not serializable: " + notSerializableException.getMessage() + ".\nWriting of file " + string + " aborted.";
                    stack = renewObjectOutputStream.getDomainTrace();
                }
                catch (Exception exception) {
                    string2 = "Problem encountered while writing file " + string + ": " + exception;
                }
                catch (StackOverflowError stackOverflowError) {
                    string2 = "StackOverflowError: Probably the recursion in Java's serialization mechanism went too deep.\nIf you are using JDK 1.1, try setting the java options  -ss... and/or -oss... to increase native and java stack sizes. Setting -ss1m was appropriate for us.";
                }
                try {
                    if (renewObjectOutputStream != null) {
                        renewObjectOutputStream.close();
                    }
                    if (string2 == null) {
                        string2 = "Simulation state saved to " + string + ".";
                    }
                }
                catch (Exception exception) {
                    if (string2 != null) break block11;
                    string2 = "Problem encountered while closing file " + string + ": " + exception;
                }
            }
            if (stack != null) {
                this.displaySaveSimError(stack, string2);
                return;
            }
            this.showStatus(string2);
            System.err.println(string2);
        }
    }

    private void displaySaveSimError(Stack stack, String string) {
        FigureWithID figureWithID;
        Object object;
        Net net = null;
        NetInstance netInstance = null;
        int n = 0;
        String string2 = null;
        String string3 = null;
        Object object2 = null;
        try {
            object2 = stack.peek();
            if (object2 instanceof PlaceInstance) {
                object = (PlaceInstance)object2;
                n = ((PlaceInstance)object).getPlace().getID();
                netInstance = ((PlaceInstance)object).getNetInstance();
                net = netInstance.getNet();
            } else if (object2 instanceof TransitionInstance) {
                object = (TransitionInstance)object2;
                n = ((TransitionInstance)object).getTransition().getID();
                netInstance = ((TransitionInstance)object).getNetInstance();
                net = netInstance.getNet();
            } else if (object2 instanceof Place) {
                string2 = "place " + object2;
                n = ((Place)object2).getID();
            } else if (object2 instanceof Transition) {
                string2 = "transition " + object2;
                n = ((Transition)object2).getID();
            } else if (object2 instanceof Net) {
                string2 = "net " + object2;
                net = (Net)object2;
            } else if (object2 instanceof NetInstance) {
                string2 = "net instance " + object2;
                netInstance = (NetInstance)object2;
                net = netInstance.getNet();
            } else if (object2 == (class$de$renew$gui$CPNInstanceDrawing != null ? class$de$renew$gui$CPNInstanceDrawing : (class$de$renew$gui$CPNInstanceDrawing = CPNApplication.class$("de.renew.gui.CPNInstanceDrawing")))) {
                string2 = "instance drawings";
            } else if (object2 == (class$de$renew$simulator$Net != null ? class$de$renew$simulator$Net : (class$de$renew$simulator$Net = CPNApplication.class$("de.renew.simulator.Net")))) {
                string2 = "compiled nets";
            } else if (object2 == (class$de$renew$simulator$SearchQueue != null ? class$de$renew$simulator$SearchQueue : (class$de$renew$simulator$SearchQueue = CPNApplication.class$("de.renew.simulator.SearchQueue")))) {
                string2 = "search queue entries";
                if (string.indexOf("de.renew.call.SynchronisationRequest") >= 0) {
                    string3 = "You tried to save the simulation state while a transition with a synchronous channel was still firing. Wait until all transitions are finished.";
                }
            } else {
                string2 = "(DON'T KNOW - TRACE CONTAINS OBJECT OF UNEXPECTED TYPE: " + object2.getClass().getName() + ")";
            }
        }
        catch (EmptyStackException emptyStackException) {
            string2 = "(DON'T KNOW - TRACE IS EMPTY!?)";
        }
        if (string2 == null) {
            object = net.getName();
            string = String.valueOf(string) + "\nThe problem lies around net element " + object2 + ".";
            CPNDrawing cPNDrawing = this.fSimulation.getDrawing((String)object);
            if (cPNDrawing == null) {
                this.showStatus(string);
                System.err.println(string);
                System.err.println("Sorry, cannot show the location of the problem because net " + (String)object + " is not loaded.");
                return;
            }
            this.openInstanceDrawing(netInstance);
            CPNInstanceDrawing cPNInstanceDrawing = CPNInstanceDrawing.getInstanceDrawing(this.getMode(), netInstance);
            FigureWithID figureWithID2 = cPNDrawing.getFigureWithID(n);
            InstanceFigure instanceFigure = cPNInstanceDrawing.getInstanceFigure(figureWithID2);
            this.showStatus(string);
            System.err.println(string);
            this.processFigureException(new FigureException("Renew: Save simulation error", string, cPNInstanceDrawing, instanceFigure), false);
            return;
        }
        string = string3 == null ? String.valueOf(string) + "\nEither you tried to save a state while the " + "simulation was running (concurrent transition " + "firing or binding calculation is not allowed) " + "or the problem is an internal one." : String.valueOf(string) + "\n" + string3;
        string = String.valueOf(string) + "\nThe problem manifested itself while writing " + string2 + ".";
        string = String.valueOf(string) + "\nSerialization trace:";
        try {
            while (!stack.isEmpty()) {
                object2 = stack.pop();
                string = String.valueOf(string) + "\n    " + object2;
                if (net != null || netInstance != null) continue;
                if (object2 instanceof Net) {
                    net = (Net)object2;
                    continue;
                }
                if (!(object2 instanceof NetInstance)) continue;
                netInstance = (NetInstance)object2;
                net = netInstance.getNet();
            }
        }
        catch (EmptyStackException emptyStackException) {}
        this.showStatus(string);
        System.err.println(string);
        if (net != null && n != 0 && (object = this.fSimulation.getDrawing(net.getName())) != null && (figureWithID = ((CPNDrawing)object).getFigureWithID(n)) != null) {
            this.processFigureException(new FigureException("Renew: Save simulation error", string, (Drawing)object, figureWithID), false);
        }
    }

    private void promptLoadSimulationState() {
        String string = this.getLoadPath("Load Simulation State...", null, new String[]{"rst"});
        if (string != null) {
            TransitionInstanceFigure.closeBindingSelectionFrame();
            this.closeAllSimulationDrawings();
            String string2 = null;
            ObjectInput objectInput = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                objectInput = new RenewObjectInputStream(fileInputStream);
                this.fSimulation.loadState(objectInput, this);
            }
            catch (ObjectStreamException objectStreamException) {
                string2 = "File " + string + " is corrupted or does not " + "contain state information.";
                System.err.println(objectStreamException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string2 = "File " + string + " refers to java classes " + "which are currently not available.";
                System.err.println(classNotFoundException);
            }
            catch (IOException iOException) {
                string2 = "Problem occured while reading file " + string + ":" + iOException;
            }
            catch (StackOverflowError stackOverflowError) {
                string2 = "StackOverflowError: Probably the recursion in Java's serialization mechanism went too deep.\nIf you are using JDK 1.1, try setting the java options  -ss... and/or -oss... to increase native and java stack sizes. Setting -ss1m was appropriate for us.";
            }
            try {
                if (objectInput != null) {
                    objectInput.close();
                }
                if (string2 == null) {
                    string2 = "Simulation state restored from " + string + ".";
                }
            }
            catch (StreamCorruptedException streamCorruptedException) {
                if (string2 == null) {
                    string2 = "Problem occurred while reading file " + string + ", but all relevant information was already read. " + "Perhaps the simulation state is valid anyway.";
                    System.err.println("Exception while closing: " + streamCorruptedException);
                }
            }
            catch (Exception exception) {
                if (string2 == null) {
                    string2 = "Problem occurred while reading file " + string + ", but all relevant information was already read. " + "Perhaps the simulation state is valid anyway.";
                }
                System.err.println("Exception while closing: " + exception);
            }
            this.showStatus(string2);
            System.err.println(string2);
        }
    }

    protected StorableInput makeStorableInput(String string, boolean bl) throws FileNotFoundException {
        return new PatchingStorableInput(string, bl);
    }

    protected Dimension getDrawingViewSize() {
        return new Dimension(535, 778);
    }

    protected Dimension defaultSize() {
        return new Dimension(640, 800);
    }

    public ToolButton toolButtonForTextFigure(TextFigure textFigure) {
        if (textFigure instanceof CPNTextFigure) {
            if (textFigure instanceof DeclarationFigure) {
                return this.fDeclTB;
            }
            switch (((CPNTextFigure)textFigure).getType()) {
                case 1: {
                    return this.fInscrTB;
                }
                case 2: {
                    return this.fNameTB;
                }
            }
        }
        return super.toolButtonForTextFigure(textFigure);
    }

    protected void createAdditionalTools(Panel panel) {
        panel.add(new Canvas());
        panel.add(new Canvas());
        AbstractTool abstractTool = new TransitionFigureCreationTool(this);
        panel.add(this.createToolButton("/de/renew/gui/images/TRANS", "Transition Tool", abstractTool));
        abstractTool = new PlaceFigureCreationTool(this);
        panel.add(this.createToolButton("/de/renew/gui/images/PLACE", "Place Tool", abstractTool));
        abstractTool = new VirtualPlaceFigureCreationTool(this);
        panel.add(this.createToolButton("/de/renew/gui/images/VPLACE", "Virtual Place Tool", abstractTool));
        abstractTool = new ConnectionTool(this, ArcConnection.NormalArc);
        panel.add(this.createToolButton("/de/renew/gui/images/ARC", "Arc Tool", abstractTool));
        abstractTool = new ConnectionTool(this, ArcConnection.TestArc);
        panel.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Test Arc Tool", abstractTool));
        abstractTool = new ConnectionTool(this, ArcConnection.ReserveArc);
        panel.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Reserve Arc Tool", abstractTool));
        abstractTool = new ConnectionTool(this, DoubleArcConnection.DoubleArc);
        panel.add(this.createToolButton("/de/renew/gui/images/DARC", "Flexible Arc Tool", abstractTool));
        CPNTextFigure cPNTextFigure = CPNTextFigure.Inscription;
        abstractTool = new CPNTextTool((DrawingEditor)this, cPNTextFigure);
        this.fInscrTB = this.createToolButton("/de/renew/gui/images/INSCR", "Inscription Tool", abstractTool);
        panel.add(this.fInscrTB);
        abstractTool = new ConnectedTextTool((DrawingEditor)this, CPNTextFigure.Name);
        this.fNameTB = this.createToolButton("/de/renew/gui/images/NAME", "Name Tool", abstractTool);
        panel.add(this.fNameTB);
        abstractTool = new CPNTextTool((DrawingEditor)this, new DeclarationFigure(), false);
        this.fDeclTB = this.createToolButton("/de/renew/gui/images/DECL", "Declaration Tool", abstractTool);
        panel.add(this.fDeclTB);
        panel.add(new Canvas());
        panel.add(new Canvas());
        this.getMode().createAdditionalTools(this, panel);
    }

    protected Tool createSelectionTool() {
        return new CPNSelectionTool(this);
    }

    public static void main(String[] stringArray) {
        new CPNApplication(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class 1
    implements FigureFilter {
        private final /* synthetic */ int val$type;
        private final /* synthetic */ Class val$parentClass;

        public boolean isUsed(Figure figure) {
            return figure instanceof CPNTextFigure && this.val$parentClass.isInstance(((ChildFigure)figure).parent()) && ((CPNTextFigure)figure).getType() == this.val$type;
        }

        /* synthetic */ 1(Class clazz, int n) {
            this.val$parentClass = clazz;
            this.val$type = n;
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CPNApplication.this.fSimulation.isSimulationActive()) {
                CPNApplication.this.initSimulation();
            }
            if (CPNApplication.this.fSimulation.isSimulationActive()) {
                CPNApplication.this.showStatus("Simulation running.");
                CPNApplication.this.fSimulation.simulationRun();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            new 4(CPNApplication.this).start();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.fSimulation.simulationStop();
            CPNApplication.this.showStatus("Simulation halted.");
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.fSimulation.simulationTerminate();
            CPNApplication.this.showStatus("Simulation terminated.");
            TransitionInstanceFigure.closeBindingSelectionFrame();
            CPNApplication.this.closeAllSimulationDrawings();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.promptSaveSimulationState();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.promptLoadSimulationState();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.syntaxCheck();
        }

        /* synthetic */ 9() {
        }
    }

    private static final class 10
    implements ActionListener {
        private final /* synthetic */ String val$upperName;
        private final /* synthetic */ int val$lintNr;
        private final /* synthetic */ String val$name;
        private final /* synthetic */ CPNApplication this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.fSimulation.isSimulationActive()) {
                this.this$0.showStatus("Terminate the current simulation before a " + this.val$name + ".");
                return;
            }
            try {
                DrawingView drawingView;
                this.this$0.fSimulation.syntaxCheckOnly();
                ShadowNet shadowNet = null;
                ShadowNet shadowNet2 = null;
                Drawing drawing = this.this$0.drawing();
                if (drawing instanceof CPNDrawing) {
                    shadowNet = ((CPNDrawing)drawing).getShadow();
                }
                if ((drawingView = this.this$0.previousView()) != null && drawingView.drawing() instanceof CPNDrawing) {
                    shadowNet2 = ((CPNDrawing)drawingView.drawing()).getShadow();
                }
                ShadowNetSystem shadowNetSystem = this.this$0.fSimulation.getNetSystem();
                shadowNetSystem.getCompiler().lint(this.val$lintNr, shadowNetSystem, shadowNet, shadowNet2);
                this.this$0.showStatus(String.valueOf(this.val$upperName) + " successful.");
                this.this$0.closeSyntaxErrorFrame();
                return;
            }
            catch (SyntaxException syntaxException) {
                this.this$0.processSyntaxException(new FigureException(syntaxException), true);
                return;
            }
        }

        /* synthetic */ 10(int n, String string, CPNApplication cPNApplication, String string2) {
            this.val$lintNr = n;
            this.val$name = string;
            this.this$0 = cPNApplication;
            this.val$upperName = string2;
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (CPNApplication.this.drawing() instanceof CPNDrawing && CPNApplication.this.view().selectionCount() == 2) {
                Vector vector = CPNApplication.this.view().selection();
                int n = -1;
                if (vector.elementAt(0) instanceof FigureWithHighlight) {
                    n = 0;
                } else if (vector.elementAt(1) instanceof FigureWithHighlight) {
                    n = 1;
                }
                if (n >= 0) {
                    FigureWithHighlight figureWithHighlight = (FigureWithHighlight)vector.elementAt(n);
                    Figure figure = (Figure)vector.elementAt(1 - n);
                    ((CPNDrawing)CPNApplication.this.drawing()).setHighlightFigure(figureWithHighlight, figure);
                    CPNApplication.this.showStatus("Highlight associated!");
                    return;
                }
                CPNApplication.this.showStatus("Selection must contain a node (place or transition).");
                return;
            }
            CPNApplication.this.showStatus("Select a node (place or transition) and another figure!");
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (CPNApplication.this.drawing() instanceof CPNDrawing) {
                FigureEnumeration figureEnumeration = CPNApplication.this.view().selectionElements();
                Vector<Figure> vector = new Vector<Figure>();
                while (figureEnumeration.hasMoreElements()) {
                    Figure figure;
                    Figure figure2 = figureEnumeration.nextFigure();
                    if (!(figure2 instanceof FigureWithHighlight) || (figure = ((FigureWithHighlight)figure2).getHighlightFigure()) == null) continue;
                    vector.addElement(figure);
                }
                if (vector.isEmpty()) {
                    CPNApplication.this.showStatus("Select some nodes (places or transitions) with highlight figures.");
                    return;
                }
                CPNApplication.this.view().clearSelection();
                CPNApplication.this.view().addToSelectionAll(vector);
                CPNApplication.this.view().repairDamage();
                CPNApplication.this.showStatus("Highlight(s) selected!");
            }
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Figure figure;
            if (CPNApplication.this.drawing() instanceof CPNDrawing && CPNApplication.this.view().selectionCount() == 1 && (figure = (Figure)CPNApplication.this.view().selection().elementAt(0)) instanceof FigureWithHighlight) {
                FigureWithHighlight figureWithHighlight = (FigureWithHighlight)figure;
                ((CPNDrawing)CPNApplication.this.drawing()).setHighlightFigure(figureWithHighlight, null);
                CPNApplication.this.showStatus("Highlight unassociated!");
                return;
            }
            CPNApplication.this.showStatus("Select a single node (place or transition)!");
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (CPNApplication.this.view().selectionCount() == 1) {
                ((CPNDrawing)CPNApplication.this.drawing()).setIconFigure((AbstractFigure)CPNApplication.this.view().selectionElements().nextFigure());
            }
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.promptExportPostscript();
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.promptExportEPS();
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.promptExportMacao();
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.promptExportWoflan();
        }

        /* synthetic */ 18() {
        }
    }

    private final class 19
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.promptExportShadow();
        }

        /* synthetic */ 19() {
        }
    }

    private final class 20
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CPNApplication.this.promptImportShadow();
        }

        /* synthetic */ 20() {
        }
    }
}

