/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.StandardDrawingView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class CPNDrawingView
extends StandardDrawingView {
    private Object repaintLock = new Object();
    private transient Rectangle damage;
    private transient Rectangle committedDamage;
    private transient boolean repaintActive = false;

    public CPNDrawingView(DrawingEditor drawingEditor, int n, int n2) {
        super(drawingEditor, n, n2);
        this.setBackground(Color.white);
    }

    public void drawingInvalidated(DrawingChangeEvent drawingChangeEvent) {
        Object object = this.repaintLock;
        synchronized (object) {
            Rectangle rectangle = drawingChangeEvent.getInvalidatedRectangle();
            if (rectangle != null) {
                if (this.damage == null) {
                    this.damage = new Rectangle(rectangle);
                } else {
                    this.damage.add(rectangle);
                }
            }
            return;
        }
    }

    public void repairDamage() {
        Object object = this.repaintLock;
        synchronized (object) {
            if (this.committedDamage == null) {
                this.committedDamage = this.damage;
            } else if (this.damage != null) {
                this.committedDamage.add(this.damage);
            }
            this.damage = null;
            if (!this.repaintActive && this.committedDamage != null) {
                this.repaintActive = true;
                this.repaint(this.committedDamage.x, this.committedDamage.y, this.committedDamage.width, this.committedDamage.height);
                this.committedDamage = null;
            }
            return;
        }
    }

    public void paint(Graphics graphics) {
        Object object = this.repaintLock;
        synchronized (object) {
            this.repaintActive = true;
        }
        super.paint(graphics);
        object = this.repaintLock;
        synchronized (object) {
            if (this.committedDamage != null) {
                this.repaint(this.committedDamage.x, this.committedDamage.y, this.committedDamage.width, this.committedDamage.height);
                this.committedDamage = null;
            } else {
                this.repaintActive = false;
            }
            return;
        }
    }
}

