/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.DrawingContext;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.StandardDrawing;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.FigureLookup;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.InstanceFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.PlaceInstanceFigure;
import de.renew.gui.RenewMode;
import de.renew.gui.TransitionFigure;
import de.renew.gui.TransitionInstanceFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.simulator.Net;
import de.renew.simulator.NetInstance;
import de.renew.simulator.Place;
import de.renew.simulator.Transition;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import de.renew.util.StringUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CPNInstanceDrawing
extends StandardDrawing
implements DrawingChangeListener,
DrawingContext {
    public static String ID_MACRO = "$ID";
    private static Hashtable drawingsByInstance = new Hashtable();
    private NetInstance netInstance;
    private CPNDrawing cpnDrawing;
    private RenewMode mode;
    private Hashtable instanceLookup;
    static /* synthetic */ Class class$de$renew$gui$CPNInstanceDrawing;

    private CPNInstanceDrawing(RenewMode renewMode, NetInstance netInstance, CPNDrawing cPNDrawing) {
        this.mode = renewMode;
        this.cpnDrawing = cPNDrawing;
        this.connect(netInstance);
        this.cpnDrawing.addDrawingChangeListener(this);
    }

    RenewMode getMode() {
        return this.mode;
    }

    public NetInstance getNetInstance() {
        return this.netInstance;
    }

    public Rectangle displayBox() {
        return super.displayBox().union(this.cpnDrawing.displayBox());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CPNInstanceDrawing getInstanceDrawing(RenewMode renewMode, NetInstance netInstance) {
        Hashtable hashtable = drawingsByInstance;
        synchronized (hashtable) {
            if (drawingsByInstance.containsKey(netInstance)) {
                return (CPNInstanceDrawing)drawingsByInstance.get(netInstance);
            }
            CPNSimulation cPNSimulation = renewMode.getSimulation();
            CPNDrawing cPNDrawing = cPNSimulation.getDrawing(netInstance.getNet().getName());
            if (cPNDrawing != null) {
                return new CPNInstanceDrawing(renewMode, netInstance, cPNDrawing);
            }
            System.err.println("To display a net instance, an open drawing of the instantiated net is needed. No such drawing found for net \"" + netInstance.getNet().getName() + "\".");
            return null;
        }
    }

    public static Enumeration getDependentInstanceDrawings(CPNDrawing cPNDrawing) {
        Enumeration enumeration = drawingsByInstance.elements();
        Vector<CPNInstanceDrawing> vector = new Vector<CPNInstanceDrawing>();
        while (enumeration.hasMoreElements()) {
            CPNInstanceDrawing cPNInstanceDrawing = (CPNInstanceDrawing)enumeration.nextElement();
            if (cPNInstanceDrawing.cpnDrawing != cPNDrawing) continue;
            vector.addElement(cPNInstanceDrawing);
        }
        if (vector.size() > 0) {
            return vector.elements();
        }
        return null;
    }

    public void draw(Graphics graphics) {
        this.cpnDrawing.draw(graphics, this);
        super.draw(graphics);
    }

    public InstanceFigure getInstanceFigure(Figure figure) {
        return (InstanceFigure)this.instanceLookup.get(figure);
    }

    public boolean isHighlighted(Figure figure) {
        InstanceFigure instanceFigure;
        FigureWithHighlight figureWithHighlight = this.cpnDrawing.getFigureForHighlight(figure);
        if (figureWithHighlight != null) {
            figure = figureWithHighlight;
        }
        if ((instanceFigure = this.getInstanceFigure(figure)) != null) {
            return instanceFigure.isHighlighted();
        }
        return false;
    }

    public boolean isVisible(Figure figure) {
        return (!(figure instanceof CPNTextFigure) || ((CPNTextFigure)figure).getType() != 1 || !(((CPNTextFigure)figure).parent() instanceof PlaceFigure)) && figure != this.cpnDrawing.getIconFigure();
    }

    public String expandMacro(String string) {
        return CPNInstanceDrawing.expandMacro(string, this.netInstance);
    }

    public static String expandMacro(String string, NetInstance netInstance) {
        return StringUtil.replace(string, ID_MACRO, netInstance.getID());
    }

    public void connect(NetInstance netInstance) {
        if (netInstance != null) {
            if (this.netInstance != null) {
                drawingsByInstance.remove(this.netInstance);
            }
            this.netInstance = netInstance;
            drawingsByInstance.put(netInstance, this);
            this.setName(netInstance.toString());
            this.instanceLookup = new Hashtable();
            FigureLookup figureLookup = this.buildFigureLookup(netInstance);
            FigureEnumeration figureEnumeration = this.cpnDrawing.figures();
            while (figureEnumeration.hasMoreElements()) {
                AbstractFigure abstractFigure;
                Serializable serializable;
                AttributeFigure attributeFigure;
                Figure figure = figureEnumeration.nextFigure();
                if (figure instanceof PlaceFigure) {
                    attributeFigure = (PlaceFigure)figure;
                    serializable = attributeFigure instanceof VirtualPlaceFigure ? figureLookup.get(((VirtualPlaceFigure)attributeFigure).getPlace()) : figureLookup.get((PlaceFigure)attributeFigure);
                    if (serializable == null) continue;
                    abstractFigure = new PlaceInstanceFigure(this, (PlaceFigure)attributeFigure, netInstance.getInstance((Place)serializable));
                    this.instanceLookup.put(attributeFigure, abstractFigure);
                    this.add(abstractFigure);
                    this.sendToBack(abstractFigure);
                    continue;
                }
                if (!(figure instanceof TransitionFigure) || (serializable = figureLookup.get((TransitionFigure)(attributeFigure = (TransitionFigure)figure))) == null) continue;
                abstractFigure = new TransitionInstanceFigure(this, (TransitionFigure)attributeFigure, netInstance.getInstance((Transition)serializable));
                this.instanceLookup.put(attributeFigure, abstractFigure);
                this.add(abstractFigure);
            }
        }
    }

    private FigureLookup buildFigureLookup(NetInstance netInstance) {
        Hashtable<Integer, Serializable> hashtable = new Hashtable<Integer, Serializable>();
        Hashtable<FigureWithID, Serializable> hashtable2 = null;
        Net net = netInstance.getNet();
        String string = net.getName();
        CPNDrawing cPNDrawing = this.mode.getSimulation().getDrawing(string);
        if (cPNDrawing == null) {
            System.err.println("No open drawing found matching the  compiled net \"" + string + "\"");
        } else {
            Transition transition;
            int n;
            Place place;
            hashtable2 = new Hashtable<FigureWithID, Serializable>();
            Enumeration enumeration = net.places();
            while (enumeration.hasMoreElements()) {
                place = (Place)enumeration.nextElement();
                n = place.getID();
                hashtable.put(new Integer(n), place);
            }
            enumeration = net.transitions();
            while (enumeration.hasMoreElements()) {
                transition = (Transition)enumeration.nextElement();
                n = transition.getID();
                hashtable.put(new Integer(n), transition);
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            enumeration = hashtable.keys();
            while (!bl4 && enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                if (cPNDrawing.getFigureWithID(n) != null) continue;
                bl = true;
            }
            enumeration = cPNDrawing.figures();
            while (!bl4 && enumeration.hasMoreElements()) {
                FigureWithID figureWithID;
                try {
                    figureWithID = (FigureWithID)enumeration.nextElement();
                }
                catch (ClassCastException classCastException) {
                    figureWithID = null;
                }
                if (figureWithID == null) continue;
                n = figureWithID.getID();
                if (figureWithID instanceof PlaceFigure) {
                    try {
                        place = (Place)hashtable.get(new Integer(n));
                        if (place != null) {
                            hashtable2.put(figureWithID, place);
                            continue;
                        }
                        bl2 = true;
                    }
                    catch (ClassCastException classCastException) {
                        bl3 = true;
                    }
                    continue;
                }
                if (!(figureWithID instanceof TransitionFigure)) continue;
                try {
                    transition = (Transition)hashtable.get(new Integer(n));
                    if (transition != null) {
                        hashtable2.put(figureWithID, transition);
                        continue;
                    }
                    bl2 = true;
                }
                catch (ClassCastException classCastException) {
                    bl3 = true;
                }
            }
            if (bl) {
                System.err.println("Warning: Drawing \"" + string + "\"" + " does not contain one or more net" + " elements found in the compiled net.");
                System.err.println("Some logical elements will not be displayed.");
            }
            if (bl2) {
                System.err.println("Warning: Drawing \"" + string + "\"" + " contains graphical net elements" + " not found in the compiled net.");
                System.err.println("Some graphical elements will not be functional.");
            }
            if (bl3) {
                System.err.println("Warning: Drawing \"" + string + "\"" + " contains graphical elements which map" + " to compiled net elements of incompatible" + " type.");
                System.err.println("Some graphical elements will not be functional.");
            }
            if (bl4) {
                hashtable2 = null;
            }
        }
        FigureLookup figureLookup = new FigureLookup(hashtable2);
        return figureLookup;
    }

    public void release() {
        this.cpnDrawing.removeDrawingChangeListener(this);
        if (this.netInstance != null) {
            drawingsByInstance.remove(this.netInstance);
            this.instanceLookup = null;
            this.netInstance = null;
        }
        super.release();
    }

    public void drawingInvalidated(DrawingChangeEvent drawingChangeEvent) {
        DrawingChangeEvent drawingChangeEvent2 = new DrawingChangeEvent(this, drawingChangeEvent.getInvalidatedRectangle());
        Enumeration enumeration = this.drawingChangeListeners();
        while (enumeration.hasMoreElements()) {
            DrawingChangeListener drawingChangeListener = (DrawingChangeListener)enumeration.nextElement();
            drawingChangeListener.drawingInvalidated(drawingChangeEvent2);
            drawingChangeListener.drawingRequestUpdate(drawingChangeEvent2);
        }
    }

    public void drawingRequestUpdate(DrawingChangeEvent drawingChangeEvent) {
    }

    public boolean isModified() {
        return false;
    }

    public static void saveAllInstances(ObjectOutput objectOutput) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutput instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutput;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(class$de$renew$gui$CPNInstanceDrawing != null ? class$de$renew$gui$CPNInstanceDrawing : (class$de$renew$gui$CPNInstanceDrawing = CPNInstanceDrawing.class$("de.renew.gui.CPNInstanceDrawing")));
        }
        TransitionInstanceFigure.closeBindingSelectionFrame();
        objectOutput.writeInt(drawingsByInstance.size());
        Enumeration enumeration = drawingsByInstance.keys();
        while (enumeration.hasMoreElements()) {
            objectOutput.writeObject(enumeration.nextElement());
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.writeDelayedObjects();
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain(class$de$renew$gui$CPNInstanceDrawing != null ? class$de$renew$gui$CPNInstanceDrawing : (class$de$renew$gui$CPNInstanceDrawing = CPNInstanceDrawing.class$("de.renew.gui.CPNInstanceDrawing")));
        }
    }

    public static Enumeration loadInstances(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        Vector<NetInstance> vector = new Vector<NetInstance>(n);
        try {
            int n2 = 0;
            while (n2 < n) {
                vector.addElement((NetInstance)ClassSource.readObject(objectInput));
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("Object other than NetInstance found when looking for net instances: " + classCastException);
        }
        if (objectInput instanceof RenewObjectInputStream) {
            ((RenewObjectInputStream)objectInput).readDelayedObjects();
        }
        return vector.elements();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

