/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.DrawingEditor;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.ClassSourceResetCompiler;
import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import de.renew.simulator.ConcurrentSimulator;
import de.renew.simulator.ConsoleTracer;
import de.renew.simulator.Net;
import de.renew.simulator.NetInstance;
import de.renew.simulator.ParallelSimulator;
import de.renew.simulator.SearchQueue;
import de.renew.simulator.SequentialSimulator;
import de.renew.simulator.Simulator;
import de.renew.simulator.SimulatorHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Vector;

public class CPNSimulation {
    private ShadowNetSystem netSystem;
    private Vector drawings = new Vector();
    private Simulator simulator;
    private boolean onlySequential;
    private static final int STATE_STREAM_VERSION = 3;
    private static final String STATE_STREAM_LABEL = "RenewState";
    private static boolean classReinit = Boolean.getBoolean("de.renew.classReinit");
    private static int simulatorMultiplicity;

    public CPNSimulation(ShadowCompiler shadowCompiler, boolean bl) {
        if (classReinit) {
            shadowCompiler = new ClassSourceResetCompiler(shadowCompiler);
        }
        this.netSystem = new ShadowNetSystem(shadowCompiler);
        this.onlySequential = bl;
    }

    void addDrawing(CPNDrawing cPNDrawing) {
        Vector vector = this.drawings;
        synchronized (vector) {
            this.drawings.addElement(cPNDrawing);
            return;
        }
    }

    void releaseDrawing(CPNDrawing cPNDrawing) {
        Vector vector = this.drawings;
        synchronized (vector) {
            this.drawings.removeElement(cPNDrawing);
        }
        cPNDrawing.discardShadow();
    }

    CPNDrawing getDrawing(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = this.drawings;
        synchronized (vector) {
            int n = 0;
            while (n < this.drawings.size()) {
                CPNDrawing cPNDrawing = (CPNDrawing)this.drawings.elementAt(n);
                String string2 = cPNDrawing.getName();
                if (string.equals(string2)) {
                    CPNDrawing cPNDrawing2 = cPNDrawing;
                    Object var4_7 = null;
                    return cPNDrawing2;
                }
                ++n;
            }
        }
        return null;
    }

    public void buildAllShadows() {
        Vector vector = this.drawings;
        synchronized (vector) {
            int n = 0;
            while (n < this.drawings.size()) {
                CPNDrawing cPNDrawing = (CPNDrawing)this.drawings.elementAt(n);
                cPNDrawing.buildShadow(this.netSystem);
                ++n;
            }
            return;
        }
    }

    public ShadowNetSystem getNetSystem() {
        return this.netSystem;
    }

    private ShadowLookup compile() throws SyntaxException {
        this.buildAllShadows();
        Net.forgetAllNets();
        ShadowLookup shadowLookup = this.netSystem.compile();
        return shadowLookup;
    }

    public void syntaxCheckOnly() throws SyntaxException {
        this.compile();
    }

    public NetInstance initSimulation(String string, DrawingEditor drawingEditor) throws SyntaxException {
        this.simulationTerminate();
        ShadowLookup shadowLookup = this.compile();
        Net net = shadowLookup.getNet(string);
        this.simulator = null;
        if (net != null) {
            NetInstance netInstance = SimulatorHelper.fireInitially(net, new ConsoleTracer("Initially", "(0) "), true);
            if (netInstance != null) {
                this.newSimulator();
            }
            return netInstance;
        }
        return null;
    }

    private void newSimulator() {
        if (simulatorMultiplicity == 0 || this.onlySequential) {
            this.simulator = new SequentialSimulator();
            return;
        }
        if (simulatorMultiplicity == 1) {
            this.simulator = new ConcurrentSimulator();
            return;
        }
        this.simulator = new ParallelSimulator(simulatorMultiplicity);
    }

    public void saveState(ObjectOutput objectOutput) throws IOException {
        CPNSimulation cPNSimulation = this;
        synchronized (cPNSimulation) {
            if (this.simulator != null) {
                this.simulationStop();
                objectOutput.writeObject(STATE_STREAM_LABEL);
                objectOutput.writeInt(3);
                objectOutput.writeInt(simulatorMultiplicity);
                CPNInstanceDrawing.saveAllInstances(objectOutput);
                Net.saveAllNets(objectOutput);
                SearchQueue.saveQueue(objectOutput);
            }
            return;
        }
    }

    public void loadState(ObjectInput objectInput, CPNApplication cPNApplication) throws IOException, ClassNotFoundException {
        CPNSimulation cPNSimulation = this;
        synchronized (cPNSimulation) {
            Enumeration enumeration;
            Object object;
            this.simulationTerminate();
            if (classReinit) {
                ClassSourceResetCompiler.setupClassSource();
            }
            Net.forgetAllNets();
            System.out.println("Loading simulation state...");
            try {
                int n;
                object = (String)objectInput.readObject();
                if (!((String)object).equals(STATE_STREAM_LABEL)) {
                    throw new StreamCorruptedException("Stream does not seem to contain renew state data.");
                }
                int n2 = objectInput.readInt();
                if (n2 != 3 && n2 != 2) {
                    System.err.println("Warning: State data is of different version (" + n2 + ") than the current (" + 3 + ").");
                    System.err.println("Trying to read it anyway, expecting errors.");
                }
                if ((n = objectInput.readInt()) != simulatorMultiplicity) {
                    System.err.println("Warning: Simulation state was saved using a different simulator multiplicity (" + n + ") " + "than currently selected (" + simulatorMultiplicity + ").");
                }
                enumeration = CPNInstanceDrawing.loadInstances(objectInput);
                Net.loadNets(objectInput);
                SearchQueue.loadQueue(objectInput);
            }
            catch (IOException iOException) {
                this.simulationTerminate();
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.simulationTerminate();
                throw classNotFoundException;
            }
            catch (StackOverflowError stackOverflowError) {
                this.simulationTerminate();
                throw stackOverflowError;
            }
            this.newSimulator();
            while (enumeration.hasMoreElements()) {
                object = (NetInstance)enumeration.nextElement();
                cPNApplication.openInstanceDrawing((NetInstance)object);
            }
            return;
        }
    }

    public boolean isSimulationActive() {
        return this.simulator != null && this.simulator.isActive();
    }

    public void simulationTerminate() {
        CPNSimulation cPNSimulation = this;
        synchronized (cPNSimulation) {
            if (this.simulator != null) {
                Simulator simulator = this.simulator;
                this.simulator = null;
                simulator.terminateRun();
            }
            SearchQueue.reset();
            return;
        }
    }

    public void simulationStop() {
        if (this.simulator != null) {
            this.simulator.stopRun();
        }
    }

    public void simulationRun() {
        CPNSimulation cPNSimulation = this;
        synchronized (cPNSimulation) {
            if (this.simulator != null) {
                this.simulator.startRun();
            }
            return;
        }
    }

    public int simulationStep() {
        CPNSimulation cPNSimulation = this;
        synchronized (cPNSimulation) {
            if (this.simulator != null) {
                int n = this.simulator.step();
                Object var3_4 = null;
                return n;
            }
            int n = 4;
            Object var3_5 = null;
            return n;
        }
    }

    static {
        if (classReinit) {
            System.err.println("Using Class Reinit mode.");
        }
        if ((simulatorMultiplicity = Integer.getInteger("de.renew.simulatorMode", 1).intValue()) == 0 || simulatorMultiplicity == -1) {
            simulatorMultiplicity = 0;
            System.err.println("Using sequential simulator ...");
        } else if (simulatorMultiplicity < -1) {
            System.err.println("Using " + -simulatorMultiplicity + " sequential simulators ...");
            System.err.println("Caution! This is an experimental feature!");
        } else if (simulatorMultiplicity > 1) {
            System.err.println("Using " + simulatorMultiplicity + " concurrent simulators ...");
            System.err.println("Caution! This is an experimental feature!");
        }
    }
}

