/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.InscribableFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNode;
import java.io.IOException;

public class CPNTextFigure
extends TextFigure
implements ShadowHolder {
    public static final int LABEL = 0;
    public static final int INSCRIPTION = 1;
    public static final int NAME = 2;
    public static final int[] STYLE;
    public static final CPNTextFigure Label;
    public static final CPNTextFigure Inscription;
    public static final CPNTextFigure Name;
    private int fType = 0;
    private ShadowInscription shadow;

    public CPNTextFigure() {
        this(0);
    }

    public CPNTextFigure(int n) {
        this(n, true);
    }

    public CPNTextFigure(int n, boolean bl) {
        super(bl);
        this.fType = n;
        this.setAttribute("FontStyle", new Integer(STYLE[n]));
    }

    public int getType() {
        return this.fType;
    }

    public void setAttribute(String string, Object object) {
        if (string.equals("TextType")) {
            int n = (Integer)object;
            if (this.canBeParent(n, this.parent())) {
                this.willChange();
                this.fType = n;
                super.setAttribute("FontStyle", new Integer(STYLE[this.fType]));
                return;
            }
        } else {
            super.setAttribute(string, object);
        }
    }

    public Object getAttribute(String string) {
        if (string.equals("TextType")) {
            return new Integer(this.fType);
        }
        return super.getAttribute(string);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fType);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fType = storableInput.readInt();
    }

    private boolean canBeParent(int n, ParentFigure parentFigure) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return parentFigure instanceof InscribableFigure;
            }
            case 2: {
                return parentFigure instanceof TransitionFigure || parentFigure instanceof PlaceFigure;
            }
        }
        return false;
    }

    public boolean canBeParent(ParentFigure parentFigure) {
        if (super.canBeParent(parentFigure)) {
            return this.canBeParent(this.fType, parentFigure);
        }
        return false;
    }

    public void release() {
        super.release();
        if (this.shadow != null) {
            this.shadow.discard();
        }
    }

    public ShadowNetElement buildShadow(ShadowNet shadowNet) {
        ShadowInscribable shadowInscribable;
        this.shadow = null;
        if (this.fType != 0 && this.parent() instanceof ShadowHolder && (shadowInscribable = (ShadowInscribable)((ShadowHolder)((Object)this.parent())).getShadow()) != null) {
            if (this.fType == 1) {
                this.shadow = new ShadowInscription(shadowInscribable, this.getText());
                this.shadow.context = this;
                this.shadow.setID(this.getID());
            } else if (shadowInscribable instanceof ShadowNode) {
                ((ShadowNode)shadowInscribable).setName(this.getText());
            }
        }
        return this.shadow;
    }

    public ShadowNetElement getShadow() {
        return this.shadow;
    }

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[2] = 1;
        STYLE = nArray;
        Label = new CPNTextFigure(0);
        Inscription = new CPNTextFigure(1);
        Name = new CPNTextFigure(2);
    }
}

