/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.TextHolder;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.FigureException;
import de.renew.gui.PlaceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;

public class CPNTextTool
extends ConnectedTextTool {
    private CPNTextFigure fTextFigure;
    private Drawing fDrawing;

    public CPNTextTool(DrawingEditor drawingEditor, CPNTextFigure cPNTextFigure) {
        super(drawingEditor, cPNTextFigure);
    }

    public CPNTextTool(DrawingEditor drawingEditor, CPNTextFigure cPNTextFigure, boolean bl) {
        super(drawingEditor, cPNTextFigure, bl);
    }

    public void beginEdit(TextHolder textHolder) {
        super.beginEdit(textHolder);
        if (textHolder instanceof CPNTextFigure) {
            this.fTextFigure = (CPNTextFigure)textHolder;
            this.fDrawing = this.fEditor.drawing();
            return;
        }
        this.fTextFigure = null;
    }

    public void endEdit() {
        super.endEdit();
        if (this.fTextFigure != null) {
            String string;
            CPNTextFigure cPNTextFigure = this.fTextFigure;
            this.fTextFigure = null;
            if (cPNTextFigure.getType() == 1 && (string = cPNTextFigure.getText()).length() > 0) {
                try {
                    CPNSimulation cPNSimulation = ((CPNApplication)this.fEditor).getMode().getSimulation();
                    cPNSimulation.buildAllShadows();
                    ShadowNetSystem shadowNetSystem = cPNSimulation.getNetSystem();
                    ShadowCompiler shadowCompiler = shadowNetSystem.getCompiler();
                    if (cPNTextFigure instanceof DeclarationFigure) {
                        this.fEditor.showStatus("Checking Declaration Node...");
                        shadowCompiler.checkDeclarationNode(string);
                    } else {
                        ShadowHolder shadowHolder = (ShadowHolder)((Object)cPNTextFigure.parent());
                        ShadowNet shadowNet = ((CPNDrawing)this.view().drawing()).buildShadow(shadowNetSystem);
                        if (shadowHolder != null && shadowNet != null) {
                            if (shadowHolder instanceof TransitionFigure) {
                                this.fEditor.showStatus("Checking Transition Inscription...");
                                shadowCompiler.checkTransitionInscription(string, shadowNet);
                            } else if (shadowHolder instanceof PlaceFigure) {
                                this.fEditor.showStatus("Checking Place Inscription...");
                                shadowCompiler.checkPlaceInscription(string, shadowNet);
                            } else if (shadowHolder instanceof ArcConnection) {
                                this.fEditor.showStatus("Checking Arc Inscription...");
                                shadowCompiler.checkArcInscription(string, shadowNet);
                            }
                        }
                    }
                    ((CPNApplication)this.fEditor).closeSyntaxErrorFrame();
                    return;
                }
                catch (SyntaxException syntaxException) {
                    this.fEditor.showStatus("A syntax error occured.");
                    FigureException figureException = new FigureException(syntaxException);
                    if (figureException.errorDrawing == null) {
                        figureException = new FigureException(syntaxException, this.fDrawing, cPNTextFigure);
                    }
                    ((CPNApplication)this.fEditor).processSyntaxException(figureException, false);
                    return;
                }
            }
        }
    }
}

