/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import de.renew.event.PlaceEvent;
import de.renew.event.PlaceEventListener;
import de.renew.event.TokenEvent;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.RenewMode;
import de.renew.gui.TokenBagFigure;
import de.renew.simulator.PlaceInstance;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class PlaceInstanceFigure
extends AbstractFigure
implements InstanceFigure,
PlaceEventListener,
FigureChangeListener {
    private PlaceFigure placeFigure;
    private PlaceInstance placeInstance;
    private boolean isMarked;
    private boolean expanded;
    private CPNInstanceDrawing drawing;

    public PlaceInstanceFigure(CPNInstanceDrawing cPNInstanceDrawing, PlaceFigure placeFigure, PlaceInstance placeInstance) {
        this.placeInstance = placeInstance;
        this.placeFigure = placeFigure;
        placeFigure.addFigureChangeListener(this);
        this.drawing = cPNInstanceDrawing;
        int n = this.placeFigure.getMarkingAppearance();
        this.expanded = n == 2;
        this.markingChanged(new PlaceEvent(this.placeInstance));
        if (n != 0) {
            this.addTokenBagFigure();
        }
        this.placeInstance.addPlaceEventListener(this);
    }

    RenewMode getMode() {
        return this.drawing.getMode();
    }

    public synchronized boolean isHighlighted() {
        return this.isMarked;
    }

    public void markingChanged(PlaceEvent placeEvent) {
        if (placeEvent.getPlaceInstance() != this.placeInstance) {
            System.out.println("Wrong PlaceEvent received!");
            throw new RuntimeException();
        }
        this.placeInstance.lock.lock();
        int n = this.placeInstance.getNumberOfTestableTokens();
        boolean bl = n > 0;
        this.placeInstance.lock.unlock();
        if (bl != this.isMarked) {
            Figure figure = this;
            synchronized (figure) {
                this.isMarked = bl;
            }
            this.invalidate();
            figure = this.placeFigure.getHighlightFigure();
            if (figure != null) {
                Rectangle rectangle = figure.displayBox();
                rectangle.grow(5, 5);
                DrawingChangeEvent drawingChangeEvent = new DrawingChangeEvent(this.drawing, rectangle);
                this.drawing.drawingInvalidated(drawingChangeEvent);
            }
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent(this));
            }
        }
    }

    public void tokenAdded(TokenEvent tokenEvent) {
        this.markingChanged(new PlaceEvent(tokenEvent.getPlaceInstance()));
    }

    public void tokenRemoved(TokenEvent tokenEvent) {
        this.tokenAdded(tokenEvent);
    }

    public void tokenTested(TokenEvent tokenEvent) {
        this.tokenAdded(tokenEvent);
    }

    public void tokenUntested(TokenEvent tokenEvent) {
        this.tokenAdded(tokenEvent);
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public Vector handles() {
        Vector<NullHandle> vector = new Vector<NullHandle>();
        vector.addElement(new NullHandle(this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle(this, RelativeLocator.southWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return vector;
    }

    public Rectangle displayBox() {
        return this.placeFigure.displayBox();
    }

    protected void basicMoveBy(int n, int n2) {
    }

    public void draw(Graphics graphics) {
    }

    private TokenBagFigure addTokenBagFigure() {
        TokenBagFigure tokenBagFigure = new TokenBagFigure(this.getMode(), this, this.placeInstance, this.expanded);
        this.drawing.add(tokenBagFigure);
        return tokenBagFigure;
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            ((CPNApplication)drawingView.editor()).openTokenBagDrawing(this.placeInstance);
            return true;
        }
        if (this.getTokenBagFigure() == null) {
            drawingView.clearSelection();
            drawingView.addToSelection(this.addTokenBagFigure());
            return true;
        }
        return super.inspect(drawingView, bl);
    }

    public void setAttribute(String string, Object object) {
        if ("MarkingAppearance".equals(string)) {
            int n = (Integer)object;
            TokenBagFigure tokenBagFigure = this.getTokenBagFigure();
            if (n == 0) {
                if (tokenBagFigure != null) {
                    this.drawing.remove(tokenBagFigure);
                    return;
                }
            } else {
                boolean bl = this.expanded = n == 2;
                if (tokenBagFigure == null) {
                    this.addTokenBagFigure();
                    return;
                }
                tokenBagFigure.setExpanded(this.expanded);
            }
            return;
        }
        super.setAttribute(string, object);
    }

    public void release() {
        if (this.placeInstance != null) {
            this.placeInstance.removePlaceEventListener(this);
            this.placeInstance = null;
            this.drawing = null;
        }
        this.placeFigure.removeFigureChangeListener(this);
        super.release();
    }

    private TokenBagFigure getTokenBagFigure() {
        FigureEnumeration figureEnumeration = this.children();
        if (figureEnumeration.hasMoreElements()) {
            return (TokenBagFigure)figureEnumeration.nextElement();
        }
        return null;
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.changed();
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }
}

