/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import collections.CollectionEnumeration;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNode;
import de.renew.shadow.ShadowTransition;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Hashtable;

class ShadowNetRenderer {
    CPNDrawing drawing = new CPNDrawing();
    private Hashtable lookup = new Hashtable();
    private Point loc = new Point(100, 20);

    ShadowNetRenderer(ShadowNet shadowNet) {
        this.render(shadowNet);
    }

    private void render(ShadowNet shadowNet) {
        Object e;
        this.drawing.setName(shadowNet.getName());
        CollectionEnumeration collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            e = collectionEnumeration.nextElement();
            if (e instanceof ShadowNode) {
                this.renderNode((ShadowNode)e);
            }
            if (!(e instanceof ShadowDeclarationNode)) continue;
            this.renderDeclarationNode((ShadowDeclarationNode)e);
        }
        collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            e = collectionEnumeration.nextElement();
            if (!(e instanceof ShadowArc)) continue;
            this.renderArc((ShadowArc)e);
        }
        collectionEnumeration = shadowNet.elements();
        while (collectionEnumeration.hasMoreElements()) {
            e = collectionEnumeration.nextElement();
            if (!(e instanceof ShadowInscription)) continue;
            this.renderInscription((ShadowInscription)e);
        }
    }

    private void renderDeclarationNode(ShadowDeclarationNode shadowDeclarationNode) {
        DeclarationFigure declarationFigure = new DeclarationFigure();
        declarationFigure.setText(shadowDeclarationNode.inscr);
        this.drawing.add(declarationFigure);
    }

    private void renderNode(ShadowNode shadowNode) {
        Dimension dimension = null;
        AttributeFigure attributeFigure = null;
        if (shadowNode instanceof ShadowTransition) {
            attributeFigure = new TransitionFigure();
            dimension = TransitionFigure.defaultDimension();
        } else {
            attributeFigure = new PlaceFigure();
            PlaceFigure cfr_ignored_0 = (PlaceFigure)attributeFigure;
            dimension = PlaceFigure.defaultDimension();
        }
        Point point = new Point(dimension.width, dimension.height);
        attributeFigure.displayBox(new Point(), point);
        attributeFigure.moveBy(this.loc.x, this.loc.y);
        this.drawing.add(attributeFigure);
        this.lookup.put(shadowNode, attributeFigure);
        if (shadowNode.getName() != null) {
            CPNTextFigure cPNTextFigure = new CPNTextFigure(2);
            cPNTextFigure.setText(shadowNode.getName());
            this.drawing.add(cPNTextFigure);
            cPNTextFigure.setParent(attributeFigure);
        }
        attributeFigure.setAttribute("TraceMode", new Boolean(shadowNode.getTrace()));
    }

    private void renderArc(ShadowArc shadowArc) {
        Figure figure;
        int n = shadowArc.shadowArcType;
        Figure figure2 = (Figure)this.lookup.get(shadowArc.place);
        Figure figure3 = (Figure)this.lookup.get(shadowArc.transition);
        if (!shadowArc.placeToTransition) {
            figure = figure2;
            figure2 = figure3;
            figure3 = figure;
        }
        figure = new ArcConnection(n);
        ((LineConnection)figure).startPoint(0, 0);
        ((LineConnection)figure).endPoint(0, 0);
        this.drawing.add(figure);
        this.lookup.put(shadowArc, figure);
        ((LineConnection)figure).connectStart(figure2.connectorAt(0, 0));
        ((LineConnection)figure).connectEnd(figure3.connectorAt(0, 0));
        ((LineConnection)figure).updateConnection();
        ((PolyLineFigure)figure).setAttribute("TraceMode", new Boolean(shadowArc.getTrace()));
    }

    private void renderInscription(ShadowInscription shadowInscription) {
        CPNTextFigure cPNTextFigure = new CPNTextFigure(1);
        cPNTextFigure.setText(shadowInscription.inscr);
        ParentFigure parentFigure = (ParentFigure)this.lookup.get(shadowInscription.inscribable);
        this.drawing.add(cPNTextFigure);
        cPNTextFigure.setParent(parentFigure);
        cPNTextFigure.setAttribute("TraceMode", new Boolean(shadowInscription.getTrace()));
    }
}

