/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.OffsetLocator;
import collections.CollectionEnumeration;
import de.renew.event.PlaceEvent;
import de.renew.event.PlaceEventListener;
import de.renew.event.TokenEvent;
import de.renew.gui.MultipleTokenFigure;
import de.renew.gui.PlaceInstanceFigure;
import de.renew.gui.RenewMode;
import de.renew.gui.SimpleCompositeFigure;
import de.renew.simulator.PlaceInstance;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

public class TokenBagFigure
extends SimpleCompositeFigure
implements ChildFigure,
PlaceEventListener {
    private static final int BORDER = 3;
    private static final int SEPARATOR = 1;
    private OffsetLocator fLocator;
    private RenewMode mode;
    private PlaceInstanceFigure place;
    private PlaceInstance placeInstance;
    private int cacheMult = -1;
    private int cacheTestMult = -1;
    private TextFigure cardFigure;
    private FigureAttributes attributes;
    private boolean expanded;

    public TokenBagFigure() {
    }

    public TokenBagFigure(RenewMode renewMode, PlaceInstance placeInstance) {
        this(renewMode, null, placeInstance);
    }

    public TokenBagFigure(RenewMode renewMode, PlaceInstanceFigure placeInstanceFigure, PlaceInstance placeInstance) {
        this(renewMode, placeInstanceFigure, placeInstance, false);
    }

    public TokenBagFigure(RenewMode renewMode, PlaceInstanceFigure placeInstanceFigure, PlaceInstance placeInstance, boolean bl) {
        this.placeInstance = placeInstance;
        this.mode = renewMode;
        this.cardFigure = new TextFigure();
        this.cardFigure.setReadOnly(true);
        this.cardFigure.setAttribute("FontStyle", new Integer(2));
        this.attributes = new FigureAttributes();
        if (placeInstanceFigure != null) {
            this.setParent(placeInstanceFigure);
        }
        this.expanded = !bl;
        this.setExpanded(bl);
        this.placeInstance.addPlaceEventListener(this);
    }

    public boolean canBeParent(ParentFigure parentFigure) {
        return parentFigure instanceof PlaceInstanceFigure;
    }

    private void unsetParent() {
        if (this.place != null) {
            this.place.removeChild(this);
            this.place = null;
        }
    }

    public boolean setParent(ParentFigure parentFigure) {
        if (!this.canBeParent(parentFigure)) {
            return false;
        }
        if (this.place == parentFigure) {
            return true;
        }
        this.unsetParent();
        this.place = (PlaceInstanceFigure)parentFigure;
        if (this.place == null) {
            this.fLocator = null;
        } else {
            this.place.addChild(this);
            if (this.fLocator != null) {
                this.fLocator.setBase(this.place.connectedTextLocator(this));
            } else {
                this.fLocator = new OffsetLocator(this.place.connectedTextLocator(this));
            }
            this.updateLocation();
        }
        return true;
    }

    public ParentFigure parent() {
        return this.place;
    }

    protected void layout() {
        Point point = this.displayBox().getLocation();
        point.translate(3, 3);
        Dimension dimension = new Dimension(0, 0);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Dimension dimension2 = figure.size();
            Point point2 = new Point(point.x + dimension2.width, point.y + dimension2.height);
            figure.basicDisplayBox(point, point2);
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height + 1;
            point.y += dimension2.height + 1;
        }
        this.fDisplayBox.width = dimension.width + 6;
        this.fDisplayBox.height = dimension.height - 1 + 6;
        this.updateLocation();
    }

    protected boolean needsLayout() {
        Dimension dimension = new Dimension(0, 5);
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            dimension.width = Math.max(dimension.width, figure.size().width);
            dimension.height += figure.size().height + 1;
        }
        dimension.width += 6;
        return !dimension.equals(this.fDisplayBox.getSize());
    }

    public void moveBy(int n, int n2) {
        super.moveBy(n, n2);
        if (this.fLocator != null) {
            this.fLocator.moveBy(n, n2);
        }
    }

    public void updateLocation() {
        if (this.fLocator != null) {
            Point point = this.fLocator.locate(this.place);
            Rectangle rectangle = this.displayBox();
            point.x -= rectangle.x + rectangle.width / 2;
            point.y -= rectangle.y + rectangle.height / 2;
            if (point.x != 0 || point.y != 0) {
                this.willChange();
                this.basicMoveBy(point.x, point.y);
                this.changed();
            }
        }
    }

    public void markingChanged(PlaceEvent placeEvent) {
        if (placeEvent.getPlaceInstance() != this.placeInstance) {
            System.out.println("Wrong PlaceEvent received!");
            throw new RuntimeException();
        }
        if (!this.expanded) {
            this.updateCardFigure();
            return;
        }
        this.placeInstance.lock.lock();
        this.removeAll();
        CollectionEnumeration collectionEnumeration = this.placeInstance.getDistinctTestableTokens();
        this.willChange();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            int n = this.placeInstance.getTokenCount(e);
            boolean bl = this.placeInstance.containsTestedToken(e);
            MultipleTokenFigure multipleTokenFigure = new MultipleTokenFigure(this.mode, n, bl, e);
            Enumeration enumeration = this.attributes.definedAttributes();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                multipleTokenFigure.setAttribute(string, this.attributes.get(string));
            }
            this.add(multipleTokenFigure);
        }
        this.placeInstance.lock.unlock();
        this.layout();
        this.changed();
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(new FigureChangeEvent(this));
        }
    }

    public void tokenAdded(TokenEvent tokenEvent) {
        this.markingChanged(new PlaceEvent(tokenEvent.getPlaceInstance()));
    }

    public void tokenRemoved(TokenEvent tokenEvent) {
        this.tokenAdded(tokenEvent);
    }

    public void tokenTested(TokenEvent tokenEvent) {
        this.tokenAdded(tokenEvent);
    }

    public void tokenUntested(TokenEvent tokenEvent) {
        this.tokenAdded(tokenEvent);
    }

    private void updateCardFigure() {
        this.placeInstance.lock.lock();
        int n = this.placeInstance.getNumberOfTokens();
        int n2 = this.placeInstance.getNumberOfTestedTokens();
        this.placeInstance.lock.unlock();
        if (n != this.cacheMult || n2 != this.cacheTestMult) {
            this.cacheMult = n;
            this.cacheTestMult = n2;
            if (n2 > 0) {
                if (n > 0) {
                    this.cardFigure.setText(String.valueOf(n) + "(" + n2 + ")");
                } else {
                    this.cardFigure.setText("(" + n2 + ")");
                }
            } else if (n > 0) {
                this.cardFigure.setText(String.valueOf(n));
            } else {
                this.cardFigure.setText(" ");
            }
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent(this));
            }
        }
    }

    public void release() {
        if (this.placeInstance != null) {
            this.placeInstance.removePlaceEventListener(this);
            this.placeInstance = null;
        }
        this.unsetParent();
        this.removeAll();
        super.release();
    }

    public String toString() {
        if (this.placeInstance == null) {
            return "Detached TokenBagFigure@" + System.identityHashCode(this);
        }
        StringBuffer stringBuffer = new StringBuffer().append('{');
        this.placeInstance.lock.lock();
        CollectionEnumeration collectionEnumeration = this.placeInstance.getDistinctTestableTokens();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            int n = this.placeInstance.getTokenCount(e);
            boolean bl = this.placeInstance.containsTestedToken(e);
            stringBuffer.append(MultipleTokenFigure.getMultString(n, bl));
            stringBuffer.append(e.toString());
            if (!collectionEnumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        this.placeInstance.lock.unlock();
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            this.willChange();
            this.expanded = bl;
            if (!bl) {
                this.removeAll();
                this.add(this.cardFigure);
            }
            this.markingChanged(new PlaceEvent(this.placeInstance));
            this.layout();
        }
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        boolean bl2 = super.inspect(drawingView, bl);
        if (bl && !bl2) {
            int n = this.expanded ? 1 : 2;
            this.setAttribute("MarkingAppearance", new Integer(n));
        }
        return bl2;
    }

    protected PlaceInstance getPlaceInstance() {
        return this.placeInstance;
    }

    public void update(FigureChangeEvent figureChangeEvent) {
        this.updateLocation();
        super.update(figureChangeEvent);
    }

    public void setAttribute(String string, Object object) {
        if (string.equals("MarkingAppearance")) {
            if (this.place != null) {
                this.place.setAttribute(string, object);
                return;
            }
            boolean bl = (Integer)object == 2;
            this.setExpanded(bl);
            return;
        }
        if (this.expanded) {
            this.attributes.set(string, object);
        }
        super.setAttribute(string, object);
    }
}

