/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.CompositeFigure;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.RenewMode;
import de.renew.gui.SimpleCompositeFigure;
import de.renew.simulator.NetInstance;
import de.renew.util.TextToken;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;

public class TokenFigure
extends SimpleCompositeFigure {
    Object token;
    private boolean expanded = true;

    /*
     * Enabled aggressive block sorting
     */
    public TokenFigure(RenewMode renewMode, Object object) {
        this.token = object;
        String string = null;
        if (object instanceof NetInstance) {
            NetInstance netInstance = (NetInstance)object;
            CPNDrawing cPNDrawing = renewMode.getSimulation().getDrawing(netInstance.getNet().toString());
            Figure figure = null;
            if (cPNDrawing != null) {
                figure = cPNDrawing.getIconFigure();
            }
            if (figure != null) {
                figure = (Figure)figure.clone();
                this.updateID(figure, netInstance);
                this.add(figure);
                this.layout();
                return;
            }
            string = netInstance.toString();
        } else {
            string = this.getText();
        }
        this.add(new TextFigure(string, true));
        this.layout();
    }

    private void updateID(Figure figure, NetInstance netInstance) {
        if (figure instanceof TextFigure) {
            TextFigure textFigure = (TextFigure)figure;
            textFigure.setReadOnly(true);
            textFigure.setText(CPNInstanceDrawing.expandMacro(textFigure.getText(), netInstance));
            return;
        }
        if (figure instanceof CompositeFigure) {
            FigureEnumeration figureEnumeration = figure.figures();
            while (figureEnumeration.hasMoreElements()) {
                this.updateID(figureEnumeration.nextFigure(), netInstance);
            }
        }
    }

    protected void layout() {
        AbstractFigure abstractFigure = (AbstractFigure)this.figures().nextFigure();
        Rectangle rectangle = abstractFigure.displayBox();
        this.fDisplayBox.setSize(rectangle.getSize());
        abstractFigure.basicDisplayBox(this.fDisplayBox.getLocation(), new Point(this.fDisplayBox.x + this.fDisplayBox.width, this.fDisplayBox.y + this.fDisplayBox.height));
    }

    protected boolean needsLayout() {
        return false;
    }

    private String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.token == null) {
            stringBuffer.append("null");
        } else {
            if (this.token instanceof String) {
                stringBuffer.append('\"').append((String)this.token).append('\"');
            } else if (this.token instanceof TextToken) {
                stringBuffer.append(((TextToken)this.token).toTokenText());
            } else {
                stringBuffer.append(this.token);
            }
            if (!this.expanded) {
                StringBuffer stringBuffer2;
                String string = this.token.getClass().getName();
                if (string.startsWith("java.lang.")) {
                    string = string.substring(10);
                }
                if ((stringBuffer2 = new StringBuffer(string).append('@').append(this.token.hashCode())).length() < stringBuffer.length()) {
                    stringBuffer = stringBuffer2;
                }
            }
        }
        return stringBuffer.toString();
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            return false;
        }
        if (this.token instanceof NetInstance) {
            ((CPNApplication)drawingView.editor()).openInstanceDrawing((NetInstance)this.token);
        } else if (this.token instanceof Window && ((Window)this.token).isShowing()) {
            ((Component)((Window)this.token)).setVisible(true);
            ((Window)this.token).requestFocus();
        } else {
            return super.inspect(drawingView, bl);
        }
        return true;
    }
}

