/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import de.renew.formalism.fs.ShadowConcept;
import de.renew.gui.NodeFigure;
import de.renew.gui.fs.AssocConnection;
import de.renew.gui.fs.IsaConnection;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class ConceptFigure
extends TextFigure
implements NodeFigure {
    private String conceptStr = "";
    private String appropStr = "";
    private static IsaConnection fgIsaPrototype = new IsaConnection();
    private static IsaConnection fgDisIsaPrototype = new IsaConnection(false);
    private static AssocConnection fgAssocPrototype = new AssocConnection();
    private ShadowConcept shadow;

    public ConceptFigure() {
        this.setAttribute("FrameColor", ColorMap.color("Black"));
        this.setAttribute("FillColor", ColorMap.color("White"));
    }

    public Vector handles() {
        Vector vector = super.handles();
        vector.addElement(new ConnectionHandle(this, RelativeLocator.north(), fgDisIsaPrototype));
        vector.addElement(new ConnectionHandle(this, RelativeLocator.south(), fgIsaPrototype));
        vector.addElement(new ConnectionHandle(this, RelativeLocator.east(), fgAssocPrototype));
        vector.addElement(new ConnectionHandle(this, RelativeLocator.west(), fgAssocPrototype));
        return vector;
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.setReadOnly(false);
        this.setParent(null);
    }

    public void drawFrame(Graphics graphics) {
        super.drawFrame(graphics);
        if (!"".equals(this.appropStr)) {
            Rectangle rectangle = this.displayBox();
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            int n = rectangle.y + fontMetrics.getHeight();
            graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
        }
    }

    public void setText(String string) {
        super.setText(string);
        int n = string.indexOf(10);
        if (n < 0) {
            this.appropStr = "";
            this.conceptStr = string;
        } else {
            this.appropStr = string.substring(n + 1).trim();
            this.conceptStr = string.substring(0, n);
        }
        this.conceptStr = this.conceptStr.trim();
    }

    public Rectangle displayBox() {
        Rectangle rectangle = super.displayBox();
        return new Rectangle(rectangle.x - 5, rectangle.y, rectangle.width + 10, rectangle.height);
    }

    public ShadowNetElement buildShadow(ShadowNet shadowNet) {
        this.shadow = new ShadowConcept(shadowNet, this.conceptStr, this.appropStr);
        this.shadow.context = this;
        return this.shadow;
    }

    public ShadowNetElement getShadow() {
        return this.shadow;
    }

    public String getName() {
        return this.conceptStr;
    }

    public void release() {
        super.release();
        if (this.shadow != null) {
            this.shadow.discard();
        }
    }

    public boolean canBeParent(ParentFigure parentFigure) {
        return parentFigure == null;
    }
}

