/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.figures.TextFigure;
import collections.HashedMap;
import de.renew.formalism.fs.FSNetParser;
import de.renew.formalism.java.ParseException;
import de.uni_hamburg.fs.EquivRelation;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.TagMap;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.StringReader;
import java.util.Vector;

public class FSFigure
extends TextFigure {
    private transient Node fs;
    private transient TagMap tagmap;
    private transient FontMetrics metrics;
    private int lineh;
    private int d;
    private int ascent;
    private transient TypeSystem ts;
    private Dimension fExtent;

    public FSFigure(FeatureStructure featureStructure) {
        this.fs = featureStructure.getRoot();
        this.tagmap = new TagMap(this.fs);
        super.setText(" ");
        this.setReadOnly(true);
        this.ts = TypeSystem.instance();
    }

    public FSFigure() {
        this.setText("[]");
        this.setReadOnly(false);
    }

    public void setText(String string) {
        super.setText(string);
        FSNetParser fSNetParser = new FSNetParser(new StringReader(string));
        this.ts = TypeSystem.instance();
        HashedMap hashedMap = new HashedMap();
        EquivRelation equivRelation = new EquivRelation();
        this.fs = null;
        try {
            this.fs = fSNetParser.parseFS(hashedMap, equivRelation, "", new Vector(), new Vector());
        }
        catch (ParseException parseException) {
            System.err.println("FS-Parse-Exception: " + parseException);
            return;
        }
        try {
            equivRelation.extensionalize();
        }
        catch (UnificationFailure unificationFailure) {
            System.err.println("FS not extensionalizable!");
            this.fs = null;
            return;
        }
        this.fs = equivRelation.getUnificator(this.fs);
        this.tagmap = new TagMap(this.fs, equivRelation, hashedMap);
    }

    private void drawBrackets(Graphics graphics, int n, Rectangle rectangle) {
        int n2 = rectangle.y + rectangle.height - 1;
        int n3 = rectangle.x + rectangle.width - 1;
        graphics.drawPolyline(new int[]{rectangle.x + n, rectangle.x, rectangle.x, rectangle.x + n}, new int[]{rectangle.y, rectangle.y, n2, n2}, 4);
        graphics.drawPolyline(new int[]{n3 - n, n3, n3, n3 - n}, new int[]{rectangle.y, rectangle.y, n2, n2}, 4);
    }

    private void drawAngles(Graphics graphics, int n, Rectangle rectangle) {
        int n2 = rectangle.y + rectangle.height - 1;
        int n3 = rectangle.y + rectangle.height / 2;
        int n4 = rectangle.x + rectangle.width - 1;
        graphics.drawPolyline(new int[]{rectangle.x + n, rectangle.x, rectangle.x + n}, new int[]{rectangle.y, n3, n2}, 3);
        graphics.drawPolyline(new int[]{n4 - n, n4, n4 - n}, new int[]{rectangle.y, n3, n2}, 3);
    }

    private void initMetrics() {
        this.metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        this.lineh = this.metrics.getHeight();
        this.d = this.metrics.stringWidth(" ");
        this.ascent = this.metrics.getAscent();
    }

    public Rectangle displayBox() {
        Rectangle rectangle = super.displayBox();
        if (this.fs == null) {
            return rectangle;
        }
        if (this.fExtent == null) {
            this.tagmap.resetVisited();
            this.initMetrics();
            this.fExtent = this.drawFS(null, rectangle.x, rectangle.y, this.fs, Type.TOP);
        }
        return new Rectangle(rectangle.x, rectangle.y, this.fExtent.width, this.fExtent.height);
    }

    public void draw(Graphics graphics) {
        if (this.fs == null) {
            super.draw(graphics);
            return;
        }
        graphics.setColor((Color)this.getAttribute("TextColor"));
        graphics.setFont(this.getFont());
        Rectangle rectangle = super.displayBox();
        this.tagmap.resetVisited();
        this.initMetrics();
        this.fExtent = this.drawFS(graphics, rectangle.x, rectangle.y, this.fs, Type.TOP);
    }

    private Dimension drawList(Graphics graphics, int n, int n2, int n3, Node node) {
        int n4 = 0;
        Type type = node.getType();
        if (this.ts.tNEList().subsumes(type)) {
            Dimension dimension;
            Node node2 = node.hasFeature(TypeSystem.HEAD_FEATURE) ? node.delta(TypeSystem.HEAD_FEATURE) : new FSNode();
            Dimension dimension2 = this.drawFS(graphics, n, n2, node2, Type.TOP);
            n4 = dimension2.width + this.d;
            n3 = Math.max(n3, dimension2.height);
            Node node3 = node.hasFeature(TypeSystem.TAIL_FEATURE) ? node.delta(TypeSystem.TAIL_FEATURE) : new FSNode();
            if (this.tagmap.getTag(node3) == 0 || this.ts.tEList().equals(node3.getType())) {
                dimension = this.drawList(graphics, n + n4, n2, n3, node3);
                if (dimension.width == 0) {
                    n4 -= this.d;
                }
            } else {
                dimension = this.drawFS(graphics, n + n4 + 2 * this.d, n2, node3, this.ts.tList());
                n3 = Math.max(n3, dimension.height);
                if (graphics != null) {
                    int n5 = n + n4 + this.d / 2;
                    graphics.drawLine(n5, n2, n5, n2 + n3);
                }
                n4 += 2 * this.d;
            }
            n4 += dimension.width;
            n3 = Math.max(n3, dimension.height);
        } else if (!this.ts.tEList().subsumes(type)) {
            Dimension dimension = this.drawFS(graphics, n + 2 * this.d, n2, node, Type.TOP);
            n4 = dimension.width + 2 * this.d;
            n3 = Math.max(n3, dimension.height);
            if (graphics != null) {
                graphics.drawLine(n, n2, n, n2 + n3);
            }
        }
        return new Dimension(n4, n3);
    }

    private Dimension drawFS(Graphics graphics, int n, int n2, Node node, Type type) {
        int n3 = this.lineh;
        int n4 = this.d;
        boolean bl = false;
        GraphicTag graphicTag = new GraphicTag(node);
        if (graphicTag.width > 0) {
            n += graphicTag.width + this.d;
        }
        int n5 = n + this.d;
        Type type2 = node.getType();
        Dimension dimension = new Dimension(0, this.lineh);
        if (!this.tagmap.isVisited(node) && !type2.getName().equals("_Dummy")) {
            Object object;
            this.tagmap.setVisited(node);
            if (this.ts.tList().subsumes(type2)) {
                if (!type2.equals(this.ts.tList())) {
                    object = this.drawList(graphics, n5 + 2 * this.d, n2, this.lineh, node);
                    n3 = ((Dimension)object).height;
                    n4 = ((Dimension)object).width + 4 * this.d;
                    bl = true;
                }
            } else {
                if (!type2.equals(type)) {
                    object = type2.toString();
                    if (graphics != null) {
                        graphics.drawString((String)object, n5, n2 + this.ascent);
                    }
                    n4 = this.metrics.stringWidth((String)object);
                } else {
                    n3 = 0;
                }
                object = node.featureNames();
                n3 = object.hasMoreElements() ? (n3 += this.d) : this.lineh;
                while (object.hasMoreElements()) {
                    Name name = (Name)object.nextElement();
                    if (name.toString().equals("_dummy")) continue;
                    String string = String.valueOf(name.toString()) + ":";
                    int n6 = this.d + this.metrics.stringWidth(string);
                    Dimension dimension2 = this.drawFS(graphics, n5 + n6, n2 + n3, node.delta(name), type2.appropType(name));
                    if (graphics != null) {
                        graphics.drawString(string, n5, n2 + n3 + (dimension2.height - this.lineh) / 2 + this.ascent);
                    }
                    n4 = Math.max(n4, n6 + dimension2.width);
                    n3 += dimension2.height + this.d;
                }
            }
            if (n4 > this.d || bl || graphicTag.tag == 0) {
                dimension = new Dimension(n4 + 2 * this.d, n3);
                if (graphics != null) {
                    object = new Rectangle(new Point(n, n2), dimension);
                    if (bl) {
                        this.drawAngles(graphics, 2 * this.d, (Rectangle)object);
                    } else {
                        this.drawBrackets(graphics, this.d, (Rectangle)object);
                    }
                }
            }
        }
        graphicTag.draw(graphics, n - this.d, n2, dimension);
        return dimension;
    }

    class GraphicTag {
        int tag;
        int width;
        String tagstr;

        GraphicTag(Node node) {
            FSFigure.this = FSFigure.this;
            this.tag = FSFigure.this.tagmap.getTag(node);
            if (this.tag != 0) {
                this.tagstr = String.valueOf(this.tag);
                this.width = FSFigure.this.d + FSFigure.this.metrics.stringWidth(this.tagstr);
            }
        }

        void draw(Graphics graphics, int n, int n2, Dimension dimension) {
            if (this.tag != 0) {
                if (graphics != null) {
                    int n3 = n2 + (dimension.height - FSFigure.this.lineh) / 2;
                    graphics.drawString(this.tagstr, n - this.width + FSFigure.this.d / 2, n3 + FSFigure.this.ascent);
                    graphics.drawRect(n - this.width, n3, this.width - 1, FSFigure.this.lineh - 1);
                }
                if (dimension.width != 0) {
                    dimension.width += FSFigure.this.d;
                }
                dimension.width += this.width;
            }
        }
    }
}

