/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.ElbowTextLocator;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.formalism.fs.ShadowConcept;
import de.renew.formalism.fs.ShadowIsa;
import de.renew.gui.fs.ConceptConnection;
import de.renew.gui.fs.IsaArrowTip;
import de.renew.shadow.ShadowNetElement;
import java.awt.Point;
import java.io.IOException;
import java.util.Vector;

public class IsaConnection
extends ConceptConnection {
    private boolean isDisjunctive;

    public IsaConnection() {
        this(true);
    }

    public IsaConnection(boolean bl) {
        super(new IsaArrowTip());
        this.isDisjunctive = bl;
    }

    protected ShadowNetElement createShadow(ShadowConcept shadowConcept, ShadowConcept shadowConcept2) {
        return new ShadowIsa(shadowConcept, shadowConcept2, this.isDisjunctive);
    }

    public boolean isDisjunctive() {
        return this.isDisjunctive;
    }

    public void setAttribute(String string, Object object) {
        if (string.equals("IsaType")) {
            this.isDisjunctive = (Boolean)object;
            this.willChange();
            if (!this.isDisjunctive && this.fPoints.size() > 2) {
                Point point = this.startPoint();
                Point point2 = this.endPoint();
                this.fPoints.removeAllElements();
                this.fPoints.addElement(point);
                this.fPoints.addElement(point2);
            }
            this.updateConnection();
            this.changed();
            return;
        }
        super.setAttribute(string, object);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeBoolean(this.isDisjunctive);
    }

    public void read(StorableInput storableInput) throws IOException {
        this.isDisjunctive = false;
        super.read(storableInput);
        this.isDisjunctive = storableInput.readBoolean();
    }

    public void updateConnection() {
        super.updateConnection();
        if (this.isDisjunctive) {
            this.updatePoints();
        }
    }

    public void layoutConnection() {
        if (!this.isDisjunctive) {
            super.layoutConnection();
        }
    }

    public Vector handles() {
        if (this.isDisjunctive) {
            Vector<AbstractHandle> vector = new Vector<AbstractHandle>(this.fPoints.size() * 2);
            vector.addElement(new ChangeConnectionStartHandle(this));
            int n = 1;
            while (n < this.fPoints.size() - 1) {
                vector.addElement(new NullHandle(this, PolyLineFigure.locator(n)));
                ++n;
            }
            vector.addElement(new ChangeConnectionEndHandle(this));
            int n2 = 0;
            while (n2 < this.fPoints.size() - 1) {
                vector.addElement(new ElbowHandle(this, n2));
                ++n2;
            }
            return vector;
        }
        return super.handles();
    }

    public Locator connectedTextLocator(Figure figure) {
        if (this.isDisjunctive) {
            return new ElbowTextLocator();
        }
        return super.connectedTextLocator(figure);
    }

    protected void updatePoints() {
        this.willChange();
        Point point = this.startPoint();
        Point point2 = this.endPoint();
        this.fPoints.removeAllElements();
        this.fPoints.addElement(point);
        if (point.x != point2.x && point.y != point2.y) {
            this.start().owner().displayBox();
            this.end().owner().displayBox();
            this.fPoints.addElement(new Point(point.x, (point.y + point2.y) / 2));
            this.fPoints.addElement(new Point(point2.x, (point.y + point2.y) / 2));
        }
        this.fPoints.addElement(point2);
        this.changed();
    }
}

