/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.LinkedList;
import de.renew.expression.VariableMapper;
import de.renew.simulator.Arc;
import de.renew.simulator.InhibitorExecutable;
import de.renew.simulator.InhibitorTokenCollector;
import de.renew.simulator.InputArcBinder;
import de.renew.simulator.InputArcExecutable;
import de.renew.simulator.InputTokenCollector;
import de.renew.simulator.InputTokenLister;
import de.renew.simulator.InscriptionOccurrence;
import de.renew.simulator.NetInstance;
import de.renew.simulator.OutputArcExecutable;
import de.renew.simulator.PlaceInstance;
import de.renew.simulator.Searcher;
import de.renew.simulator.TestArcExecutable;
import de.renew.simulator.TestTokenCollector;
import de.renew.simulator.TestTokenLister;
import de.renew.simulator.TokenCollector;
import de.renew.simulator.TokenLister;
import de.renew.simulator.UntestArcExecutable;
import de.renew.unify.Copier;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.PairEnumeration;
import de.renew.util.SingletonEnumeration;

class ArcOccurrence
implements InscriptionOccurrence {
    PlaceInstance placeInstance;
    VariableMapper mapper;
    Variable variable;
    Arc arc;

    ArcOccurrence(Arc arc, VariableMapper variableMapper, NetInstance netInstance) {
        this.arc = arc;
        this.mapper = variableMapper;
        this.placeInstance = netInstance.getInstance(arc.place);
    }

    public CollectionEnumeration makeBinders(Searcher searcher) throws Impossible {
        this.variable = new Variable(this.arc.expression.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker), searcher.recorder);
        LinkedList linkedList = new LinkedList();
        if (this.arc.arcType == 1) {
            searcher.calcChecker.addLateVariable(this.variable, searcher.recorder);
        } else if (this.arc.arcType == 5) {
            linkedList.insertFirst(new InputArcBinder(this.variable, null, new InhibitorTokenCollector(this.placeInstance)));
        } else {
            TokenLister tokenLister = this.arc.expression.isInvertible() ? (this.arc.isTestArc() ? new TestTokenLister(this.placeInstance) : new InputTokenLister(this.placeInstance)) : null;
            TokenCollector tokenCollector = this.arc.isTestArc() ? new TestTokenCollector(searcher.reserver, this.placeInstance) : new InputTokenCollector(searcher.reserver, this.placeInstance);
            linkedList.insertFirst(new InputArcBinder(this.variable, tokenLister, tokenCollector));
        }
        return linkedList.elements();
    }

    public CollectionEnumeration makeExecutables(Copier copier, VariableMapper variableMapper) {
        Variable variable = (Variable)copier.copy(this.variable);
        switch (this.arc.arcType) {
            case -1: {
                return new SingletonEnumeration(new InputArcExecutable(this.placeInstance, variable.getValue(), false, this.arc.getTrace()));
            }
            case 0: {
                return new PairEnumeration(new TestArcExecutable(this.placeInstance, variable.getValue(), false, this.arc.getTrace()), new UntestArcExecutable(this.placeInstance, variable, this.arc.getTrace()));
            }
            case 1: {
                return new SingletonEnumeration(new OutputArcExecutable(this.placeInstance, variable, this.arc.getTrace()));
            }
            case 2: {
                return new PairEnumeration(new InputArcExecutable(this.placeInstance, variable.getValue(), false, this.arc.getTrace()), new OutputArcExecutable(this.placeInstance, variable, this.arc.getTrace()));
            }
            case 3: {
                return new SingletonEnumeration(new InputArcExecutable(this.placeInstance, variable.getValue(), true, this.arc.getTrace()));
            }
            case 4: {
                return new SingletonEnumeration(new TestArcExecutable(this.placeInstance, variable.getValue(), true, this.arc.getTrace()));
            }
            case 5: {
                return new SingletonEnumeration(new InhibitorExecutable(this.placeInstance, variable.getValue(), this.arc.getTrace()));
            }
        }
        throw new RuntimeException("Bad arc type.");
    }
}

