/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import de.renew.simulator.Searcher;
import de.renew.simulator.SimulatorHelper;
import de.renew.simulator.Tracer;
import de.renew.simulator.TransitionOccurrence;
import de.renew.unify.Copier;
import java.util.Enumeration;
import java.util.Vector;

public class Binding {
    private CollectionEnumeration executables;
    private String description;
    public Vector occurrences;
    public Vector mappers;

    Binding(Searcher searcher) {
        this.executables = searcher.makeExecutables();
        StringBuffer stringBuffer = new StringBuffer();
        this.occurrences = new Vector();
        this.mappers = new Vector();
        CollectionEnumeration collectionEnumeration = searcher.getOccurrences();
        while (collectionEnumeration.hasMoreElements()) {
            TransitionOccurrence transitionOccurrence = (TransitionOccurrence)collectionEnumeration.nextElement();
            stringBuffer.append(transitionOccurrence.toString());
            this.occurrences.addElement(transitionOccurrence);
            this.mappers.addElement(transitionOccurrence.getMapper().makeCopy(new Copier()));
            if (!collectionEnumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        this.description = stringBuffer.toString();
    }

    public boolean execute(Tracer tracer, boolean bl) {
        if (this.executables == null) {
            throw new RuntimeException("Cannot execute binding twice.");
        }
        CollectionEnumeration collectionEnumeration = this.executables;
        this.executables = null;
        return SimulatorHelper.execute(collectionEnumeration, tracer, bl);
    }

    public String toString() {
        return this.description;
    }

    public Enumeration getOccurrences() {
        return this.occurrences.elements();
    }

    public Enumeration getMappers() {
        return this.mappers.elements();
    }
}

