/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.LinkedList;
import de.renew.simulator.ClearArc;
import de.renew.simulator.EarlyExecutable;
import de.renew.simulator.PlaceInstance;
import de.renew.simulator.Tracer;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Vector;

class ClearArcExecutable
implements EarlyExecutable {
    PlaceInstance placeInstance;
    Variable variable;
    ClearArc arc;
    Vector removedTokens;

    ClearArcExecutable(PlaceInstance placeInstance, Variable variable, ClearArc clearArc) {
        this.placeInstance = placeInstance;
        this.variable = variable;
        this.arc = clearArc;
    }

    public long lockPriority() {
        return this.placeInstance.lockOrder;
    }

    public int phase() {
        return -1;
    }

    public void lock() {
        this.placeInstance.lock.lock();
    }

    public void verify() throws Impossible {
        Object object;
        this.removedTokens = new Vector(8, 0);
        LinkedList linkedList = new LinkedList();
        linkedList.prependElements(this.placeInstance.getDistinctTokens());
        while (!linkedList.isEmpty()) {
            object = linkedList.first();
            linkedList.removeFirst();
            while (this.placeInstance.containsToken(object)) {
                this.placeInstance.removeToken(object);
                this.removedTokens.addElement(object);
            }
        }
        object = Array.newInstance(this.arc.elementType, this.removedTokens.size());
        int n = 0;
        while (n < this.removedTokens.size()) {
            Object object2 = this.removedTokens.elementAt(n);
            if (this.arc.elementType.isPrimitive()) {
                object2 = Value.unvalueAndCast(object2, this.arc.elementType);
            }
            Array.set(object, n, object2);
            ++n;
        }
        Unify.unify(this.variable, object, null);
    }

    public void execute(Tracer tracer) {
        if (this.arc.getTrace()) {
            tracer.trace("    Clearing " + this.placeInstance);
        }
    }

    public void rollback() {
        int n = 0;
        while (n < this.removedTokens.size()) {
            this.placeInstance.insertToken(this.removedTokens.elementAt(n));
            ++n;
        }
        this.removedTokens = null;
    }

    public void unlock() {
        this.placeInstance.lock.unlock();
    }
}

