/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import de.renew.simulator.AbortFinder;
import de.renew.simulator.ConsoleTracer;
import de.renew.simulator.ConsoleTracerFactory;
import de.renew.simulator.ExecuteFinder;
import de.renew.simulator.Net;
import de.renew.simulator.SearchQueue;
import de.renew.simulator.SearchQueueListener;
import de.renew.simulator.Searchable;
import de.renew.simulator.Searcher;
import de.renew.simulator.Simulator;
import de.renew.simulator.SimulatorHelper;
import de.renew.simulator.TracerFactory;
import de.renew.simulator.Triggerable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class ConcurrentSimulator
implements Runnable,
Simulator,
SearchQueueListener {
    private Searcher searcher = new Searcher();
    private Thread thread;
    private TracerFactory tracerFactory;
    private ExecuteFinder executeFinder;
    private AbortFinder abortFinder;
    private long cycle = 1L;
    private int desiredMode;
    private boolean running = true;
    private int stepStatusCode;
    private boolean searchQueueIsEmpty = false;
    private boolean alreadyRegistered = false;
    private Object threadLock = new Object();
    static /* synthetic */ Class class$de$renew$simulator$SearchQueue;

    public static void main(String[] stringArray) {
        Serializable serializable;
        if (stringArray.length != 1) {
            System.out.println("Usage: java de.renew.simulator.ConcurrentSimulator CLASS");
            System.exit(0);
        }
        Net net = null;
        try {
            serializable = Class.forName(stringArray[0]);
            net = (Net)serializable.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(stringArray[0]) + " isn't a valid net class as it seems.");
            if (exception instanceof InvocationTargetException) {
                ((InvocationTargetException)exception).getTargetException().printStackTrace();
            }
            exception.printStackTrace();
            System.exit(1);
        }
        serializable = SimulatorHelper.fireInitially(net, new ConsoleTracer("Initially", "(0) "), true);
        if (serializable != null) {
            ConcurrentSimulator concurrentSimulator = new ConcurrentSimulator();
            concurrentSimulator.startRun();
            return;
        }
        System.out.println("The net did not accept the init request.");
    }

    public ConcurrentSimulator(TracerFactory tracerFactory) {
        this.tracerFactory = tracerFactory;
        this.setupFinders();
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public ConcurrentSimulator() {
        this(new ConsoleTracerFactory(""));
    }

    private void setupFinders() {
        Object object = this.threadLock;
        synchronized (object) {
            this.executeFinder = new ExecuteFinder();
            this.abortFinder = new AbortFinder(this.executeFinder);
            return;
        }
    }

    public boolean isActive() {
        return true;
    }

    public void searchQueueNonempty() {
        Object object = this.threadLock;
        synchronized (object) {
            this.searchQueueIsEmpty = false;
            this.alreadyRegistered = false;
            this.threadLock.notifyAll();
            return;
        }
    }

    private void registerAtSearchQueue() {
        Class clazz = class$de$renew$simulator$SearchQueue != null ? class$de$renew$simulator$SearchQueue : (class$de$renew$simulator$SearchQueue = ConcurrentSimulator.class$("de.renew.simulator.SearchQueue"));
        synchronized (clazz) {
            Object object = this.threadLock;
            synchronized (object) {
                this.searchQueueIsEmpty = SearchQueue.isEmpty();
                if (this.searchQueueIsEmpty && !this.alreadyRegistered) {
                    SearchQueue.insertListener(this);
                    this.alreadyRegistered = true;
                }
            }
            return;
        }
    }

    public synchronized void terminateRun() {
        Object object = this.threadLock;
        synchronized (object) {
            this.desiredMode = -1;
            this.abortFinder.abortSearch();
            this.requestMode(-1);
            return;
        }
    }

    public void stopRun() {
        Object object = this.threadLock;
        synchronized (object) {
            this.desiredMode = 0;
            this.abortFinder.abortSearch();
            this.requestMode(0);
            return;
        }
    }

    public synchronized int step() {
        this.requestMode(1);
        return this.stepStatusCode;
    }

    public synchronized void startRun() {
        this.requestMode(2);
    }

    private void requestMode(int n) {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.desiredMode < 0) {
                Object var3_3 = null;
                return;
            }
            this.desiredMode = n;
            if (n > 0) {
                this.running = true;
            }
            this.threadLock.notifyAll();
            if (n < 2) {
                while (this.running) {
                    try {
                        this.threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block13: while (this.desiredMode >= 0) {
            Object object;
            Object object2 = this.threadLock;
            synchronized (object2) {
                while (this.searchQueueIsEmpty && this.desiredMode == 2) {
                    try {
                        this.threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.stepStatusCode = 0;
            object2 = SearchQueue.extract();
            while (object2 != null && this.desiredMode > 0) {
                this.setupFinders();
                if (this.desiredMode <= 0) continue;
                this.searcher.searchOnce(this.abortFinder, (Searchable)object2, (Triggerable)object2);
                Thread.yield();
                if (this.abortFinder.isCompleted()) {
                    SearchQueue.include((Searchable)object2);
                }
                if (this.executeFinder.isCompleted()) {
                    this.executeFinder.execute(this.tracerFactory.getTracer("Synchronously", String.valueOf(this.cycle++)), true);
                    this.setupFinders();
                    this.stepStatusCode = 1;
                    object = this.threadLock;
                    synchronized (object) {
                        if (this.desiredMode == 1) {
                            this.desiredMode = 0;
                        }
                    }
                }
                object2 = SearchQueue.extract();
            }
            if (object2 != null) {
                SearchQueue.include((Searchable)object2);
                object2 = null;
            }
            this.registerAtSearchQueue();
            object = this.threadLock;
            synchronized (object) {
                if (this.desiredMode == 1) {
                    this.desiredMode = 0;
                    this.stepStatusCode = 3;
                }
                if (this.desiredMode <= 0) {
                    this.running = false;
                    this.threadLock.notifyAll();
                }
                while (true) {
                    if (this.desiredMode != 0) {
                        continue block13;
                    }
                    try {
                        this.threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

