/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CircularList;
import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSeq;
import collections.UpdatableSet;
import de.renew.simulator.SearchQueueData;
import de.renew.simulator.Searchable;
import de.renew.util.EmptyEnumeration;

class DeterministicSearchQueue
implements SearchQueueData {
    private UpdatableSeq uncheckedSearchables;
    private UpdatableSet isUnchecked = new HashedSet();

    DeterministicSearchQueue() {
        this.init(new EmptyEnumeration());
    }

    public void include(Searchable searchable) {
        if (!this.isUnchecked.includes(searchable)) {
            this.uncheckedSearchables.insertLast(searchable);
            this.isUnchecked.include(searchable);
        }
    }

    public boolean isEmpty() {
        return this.uncheckedSearchables.isEmpty();
    }

    public Searchable extract() {
        Searchable searchable = (Searchable)this.uncheckedSearchables.first();
        this.uncheckedSearchables.exclude(searchable);
        this.isUnchecked.exclude(searchable);
        return searchable;
    }

    public CollectionEnumeration elements() {
        return this.uncheckedSearchables.elements();
    }

    public int size() {
        return this.uncheckedSearchables.size();
    }

    public void init(CollectionEnumeration collectionEnumeration) {
        this.uncheckedSearchables = new CircularList();
        this.isUnchecked = new HashedSet();
        this.uncheckedSearchables.appendElements(collectionEnumeration);
        this.isUnchecked.includeElements(this.uncheckedSearchables.elements());
    }
}

