/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import de.renew.simulator.EarlyExecutable;
import de.renew.simulator.FlexibleArc;
import de.renew.simulator.PlaceInstance;
import de.renew.simulator.Tracer;
import de.renew.unify.Impossible;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Vector;

class FlexibleInArcExecutable
implements EarlyExecutable {
    PlaceInstance placeInstance;
    Object tokens;
    FlexibleArc arc;
    Vector removedTokens;

    FlexibleInArcExecutable(PlaceInstance placeInstance, Object object, FlexibleArc flexibleArc) {
        this.placeInstance = placeInstance;
        this.tokens = object;
        this.arc = flexibleArc;
        this.removedTokens = new Vector();
    }

    public long lockPriority() {
        return this.placeInstance.lockOrder;
    }

    public int phase() {
        return -2;
    }

    public void lock() {
        this.placeInstance.lock.lock();
    }

    private void removeSingleToken(Object object) throws Impossible {
        if (this.arc.forwardFunction != null) {
            object = this.arc.forwardFunction.function(object);
        }
        this.placeInstance.removeToken(object);
        this.removedTokens.addElement(object);
    }

    public void verify() throws Impossible {
        try {
            if (this.tokens != null) {
                if (this.tokens.getClass().isArray()) {
                    int n = Array.getLength(this.tokens);
                    Class<?> clazz = this.tokens.getClass().getComponentType();
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = Array.get(this.tokens, n2);
                        if (clazz.isPrimitive()) {
                            object = new Value(object);
                        }
                        this.removeSingleToken(object);
                        ++n2;
                    }
                    return;
                }
                throw new Impossible();
            }
        }
        catch (Exception exception) {
            this.rollback();
            throw new Impossible();
        }
    }

    public void execute(Tracer tracer) {
        int n = 0;
        while (n < this.removedTokens.size()) {
            Object e = this.removedTokens.elementAt(n);
            if (this.arc.arcType == 3) {
                if (this.arc.trace) {
                    tracer.trace("    Checking " + e + " in " + this.placeInstance);
                }
                this.placeInstance.insertToken(e);
            } else if (this.arc.trace) {
                tracer.trace("    Removing " + e + " from " + this.placeInstance);
            }
            ++n;
        }
    }

    public void rollback() {
        int n = 0;
        while (n < this.removedTokens.size()) {
            this.placeInstance.insertToken(this.removedTokens.elementAt(n));
            ++n;
        }
    }

    public void unlock() {
        this.placeInstance.lock.unlock();
    }
}

