/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import de.renew.simulator.Binder;
import de.renew.simulator.BindingBadness;
import de.renew.simulator.RandomEnumeration;
import de.renew.simulator.Searcher;
import de.renew.simulator.TokenCollector;
import de.renew.simulator.TokenLister;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;

class InputArcBinder
implements Binder {
    Variable variable;
    TokenLister lister;
    TokenCollector collector;

    InputArcBinder(Variable variable, TokenLister tokenLister, TokenCollector tokenCollector) {
        this.variable = variable;
        this.lister = tokenLister;
        this.collector = tokenCollector;
    }

    public int bindingBadness(Searcher searcher) {
        if (Unify.isBound(this.variable)) {
            if (this.collector.containsToken(this.variable.getValue())) {
                return 1;
            }
            return 0;
        }
        if (this.lister == null) {
            return 10000;
        }
        this.lister.lock();
        CollectionEnumeration collectionEnumeration = this.lister.getDistinctTokens(this.variable.getValue());
        int n = BindingBadness.clip(collectionEnumeration.numberOfRemainingElements());
        this.lister.unlock();
        return n;
    }

    private void searchBound(Searcher searcher, Object object) {
        Object object2 = Unify.copyBoundValue(object);
        if (this.collector.collectToken(object2)) {
            searcher.search();
            this.collector.freeToken(object2);
        }
    }

    public void bind(Searcher searcher) {
        this.collector.registerAt(searcher);
        if (Unify.isBound(this.variable)) {
            this.searchBound(searcher, this.variable.getValue());
            return;
        }
        this.lister.lock();
        RandomEnumeration randomEnumeration = new RandomEnumeration(this.lister.getDistinctTokens(this.variable.getValue()));
        this.lister.unlock();
        while (randomEnumeration.hasMoreElements() && !searcher.isCompleted()) {
            Object e = randomEnumeration.nextElement();
            int n = searcher.recorder.checkpoint();
            try {
                Unify.unify(this.variable, e, searcher.recorder);
                this.searchBound(searcher, this.variable.getValue());
            }
            catch (Impossible impossible) {}
            searcher.recorder.restore(n);
        }
    }
}

