/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.simulator.NetInstance;
import de.renew.simulator.NetInstanceImpl;
import de.renew.simulator.Place;
import de.renew.simulator.SilentTracer;
import de.renew.simulator.Transition;
import de.renew.unify.Impossible;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Net
implements Serializable {
    static final long serialVersionUID = 4424943946669800287L;
    private static Hashtable netsByName = new Hashtable();
    UpdatableSet places = new HashedSet();
    UpdatableSet transitions = new HashedSet();
    String name;
    boolean earlyTokens = false;
    private int netCount;
    static /* synthetic */ Class class$de$renew$simulator$Net;

    public static Net forName(String string) {
        Net net = (Net)netsByName.get(string);
        if (net == null) {
            System.err.println("Net " + string + " not loaded.");
        }
        return net;
    }

    public static void forgetAllNets() {
        netsByName.clear();
    }

    public Net() {
        this.name = null;
    }

    public Net(String string) {
        this.name = string;
        if (string != null) {
            netsByName.put(string, this);
        }
    }

    public CollectionEnumeration places() {
        return this.places.elements();
    }

    public CollectionEnumeration transitions() {
        return this.transitions.elements();
    }

    int makeNetNumber() {
        return ++this.netCount;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    NetInstance makeInstance() throws Impossible {
        return new NetInstanceImpl(this);
    }

    public NetInstance buildInstance() {
        try {
            NetInstance netInstance = this.makeInstance();
            netInstance.createConfirmation(SilentTracer.INSTANCE);
            return netInstance;
        }
        catch (Impossible impossible) {
            throw new RuntimeException("Could not make net instance.");
        }
    }

    void add(Place place) {
        this.places.include(place);
    }

    void add(Transition transition) {
        this.transitions.include(transition);
    }

    void remove(Place place) {
        this.places.exclude(place);
    }

    void remove(Transition transition) {
        this.transitions.exclude(transition);
    }

    public void setEarlyTokens(boolean bl) {
        this.earlyTokens = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.name != null) {
            netsByName.put(this.name, this);
        }
    }

    public static void saveAllNets(ObjectOutput objectOutput) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutput instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutput;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(class$de$renew$simulator$Net != null ? class$de$renew$simulator$Net : (class$de$renew$simulator$Net = Net.class$("de.renew.simulator.Net")));
        }
        objectOutput.writeInt(netsByName.size());
        Enumeration enumeration = netsByName.elements();
        while (enumeration.hasMoreElements()) {
            objectOutput.writeObject(enumeration.nextElement());
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.writeDelayedObjects();
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain(class$de$renew$simulator$Net != null ? class$de$renew$simulator$Net : (class$de$renew$simulator$Net = Net.class$("de.renew.simulator.Net")));
        }
    }

    public static void loadNets(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        try {
            int n2 = 0;
            while (n2 < n) {
                Net net = (Net)ClassSource.readObject(objectInput);
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("Object other than Net found when looking for nets: " + classCastException.getMessage());
        }
        if (objectInput instanceof RenewObjectInputStream) {
            ((RenewObjectInputStream)objectInput).readDelayedObjects();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

