/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.LinkedList;
import de.renew.simulator.Net;
import de.renew.simulator.NetInstance;
import de.renew.simulator.Place;
import de.renew.simulator.PlaceInstance;
import de.renew.simulator.Tracer;
import de.renew.simulator.Transition;
import de.renew.simulator.TransitionInstance;
import de.renew.unify.Impossible;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class NetInstanceImpl
implements NetInstance {
    static final long serialVersionUID = -2765155215897090138L;
    private Hashtable instanceLookup;
    private Net net;
    private int netNum;

    protected NetInstanceImpl(Net net) throws Impossible {
        Serializable serializable;
        if (net == null) {
            throw new Impossible();
        }
        this.net = net;
        this.netNum = net.makeNetNumber();
        this.instanceLookup = new Hashtable();
        CollectionEnumeration collectionEnumeration = net.places.elements();
        while (collectionEnumeration.hasMoreElements()) {
            serializable = (Place)collectionEnumeration.nextElement();
            this.instanceLookup.put(serializable, serializable.makeInstance(this));
        }
        collectionEnumeration = net.transitions.elements();
        while (collectionEnumeration.hasMoreElements()) {
            serializable = (Transition)collectionEnumeration.nextElement();
            this.instanceLookup.put(serializable, new TransitionInstance(this, (Transition)serializable));
        }
    }

    public String toString() {
        return String.valueOf(this.net.toString()) + "[" + this.netNum + "]";
    }

    public String getID() {
        return String.valueOf(this.netNum);
    }

    public void createConfirmation(Tracer tracer) {
        Serializable serializable;
        CollectionEnumeration collectionEnumeration = this.net.transitions.elements();
        while (collectionEnumeration.hasMoreElements()) {
            serializable = (Transition)collectionEnumeration.nextElement();
            this.getInstance((Transition)serializable).createConfirmation();
        }
        collectionEnumeration = this.net.places.elements();
        while (collectionEnumeration.hasMoreElements()) {
            serializable = (Place)collectionEnumeration.nextElement();
            this.getInstance((Place)serializable).createConfirmation(tracer);
        }
    }

    public Object getInstance(Object object) {
        return this.instanceLookup.get(object);
    }

    public PlaceInstance getInstance(Place place) {
        return (PlaceInstance)this.instanceLookup.get(place);
    }

    public TransitionInstance getInstance(Transition transition) {
        return (TransitionInstance)this.instanceLookup.get(transition);
    }

    public Net getNet() {
        return this.net;
    }

    public CollectionEnumeration getUplinkProviders(String string) {
        LinkedList linkedList = new LinkedList();
        CollectionEnumeration collectionEnumeration = this.getNet().transitions.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Transition transition = (Transition)collectionEnumeration.nextElement();
            TransitionInstance transitionInstance = this.getInstance(transition);
            if (!transitionInstance.listensToChannel(string)) continue;
            linkedList.insertFirst(transitionInstance);
        }
        return linkedList.elements();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain(this);
        }
    }
}

