/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import de.renew.simulator.ConcurrentSimulator;
import de.renew.simulator.ConsoleTracerFactory;
import de.renew.simulator.SequentialSimulator;
import de.renew.simulator.Simulator;

public class ParallelSimulator
implements Simulator {
    public final int multiplicity;
    private final Simulator[] simulators;

    public ParallelSimulator(int n) {
        boolean bl;
        if (n == 0) {
            n = 1;
        }
        boolean bl2 = bl = n > 0;
        if (!bl) {
            n = -n;
        }
        this.multiplicity = n;
        this.simulators = new Simulator[n];
        int n2 = 0;
        while (n2 < n) {
            ConsoleTracerFactory consoleTracerFactory = new ConsoleTracerFactory(String.valueOf(n2) + "-");
            this.simulators[n2] = bl ? new ConcurrentSimulator(consoleTracerFactory) : new SequentialSimulator(consoleTracerFactory);
            ++n2;
        }
    }

    public boolean isActive() {
        int n = 0;
        while (n < this.multiplicity) {
            if (this.simulators[n].isActive()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void startRun() {
        int n = 0;
        while (n < this.multiplicity) {
            this.simulators[n].startRun();
            ++n;
        }
    }

    public void stopRun() {
        int n = 0;
        while (n < this.multiplicity) {
            this.simulators[n].stopRun();
            ++n;
        }
    }

    public synchronized void terminateRun() {
        int n = 0;
        while (n < this.multiplicity) {
            this.simulators[n].terminateRun();
            ++n;
        }
    }

    public synchronized int step() {
        int n = 1;
        while (n < this.multiplicity) {
            this.simulators[n].stopRun();
            ++n;
        }
        return this.simulators[0].step();
    }
}

