/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.LinkedList;
import collections.UpdatableSeq;
import collections.UpdatableSet;
import de.renew.event.PlaceEvent;
import de.renew.event.PlaceEventListener;
import de.renew.event.PlaceEventProducer;
import de.renew.event.TokenEvent;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableMapper;
import de.renew.simulator.NetInstance;
import de.renew.simulator.Place;
import de.renew.simulator.TokenBag;
import de.renew.simulator.TokenSource;
import de.renew.simulator.Tracer;
import de.renew.simulator.TriggerableCollection;
import de.renew.unify.Impossible;
import de.renew.unify.TupleIndex;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.Lock;
import de.renew.util.Null;
import de.renew.util.Orderer;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PlaceInstance
implements PlaceEventProducer,
Serializable,
DelayedFieldOwner {
    static final long serialVersionUID = -6409146722455348472L;
    private NetInstance netInstance;
    private Place place;
    private transient TokenBag freeTokens;
    private transient TokenBag testedTokens;
    private transient int bagCounter;
    private UpdatableSeq initTokens;
    private transient TupleIndex freeIndex;
    private transient TupleIndex testIndex;
    private transient TriggerableCollection triggerables;
    public transient long lockOrder;
    public transient Lock lock;
    private transient UpdatableSet listeners = new HashedSet();

    PlaceInstance(NetInstance netInstance, Place place) throws Impossible {
        this.netInstance = netInstance;
        this.place = place;
        this.lockOrder = Orderer.getTicket();
        this.lock = new Lock();
        this.freeTokens = new TokenBag();
        this.testedTokens = new TokenBag();
        this.freeIndex = new TupleIndex();
        this.testIndex = new TupleIndex();
        this.triggerables = new TriggerableCollection();
        this.initTokens = new LinkedList();
        CollectionEnumeration collectionEnumeration = place.inscriptions.elements();
        while (collectionEnumeration.hasMoreElements()) {
            VariableMapper variableMapper = new VariableMapper();
            Variable variable = variableMapper.map(new LocalVariable("this"));
            Unify.unify(variable, netInstance, null);
            TokenSource tokenSource = (TokenSource)collectionEnumeration.nextElement();
            Object object = tokenSource.createToken(variableMapper);
            if (netInstance.getNet().earlyTokens) {
                this.silentlyInsertToken(object);
                continue;
            }
            this.initTokens.insertFirst(Null.convert(object));
        }
    }

    public String toString() {
        return String.valueOf(this.netInstance.toString()) + "." + this.place.toString();
    }

    public NetInstance getNetInstance() {
        return this.netInstance;
    }

    public Place getPlace() {
        return this.place;
    }

    public TriggerableCollection triggerables() {
        return this.triggerables;
    }

    public void addPlaceEventListener(PlaceEventListener placeEventListener) {
        UpdatableSet updatableSet = this.listeners;
        synchronized (updatableSet) {
            this.listeners.include(placeEventListener);
            return;
        }
    }

    public void removePlaceEventListener(PlaceEventListener placeEventListener) {
        UpdatableSet updatableSet = this.listeners;
        synchronized (updatableSet) {
            this.listeners.exclude(placeEventListener);
            return;
        }
    }

    public CollectionEnumeration getDistinctTokens() {
        return this.freeIndex.getAllElements();
    }

    public CollectionEnumeration getDistinctTokens(Object object) {
        return this.freeIndex.getPossibleMatches(object);
    }

    public CollectionEnumeration getDistinctTestableTokens() {
        return this.testIndex.getAllElements();
    }

    public CollectionEnumeration getDistinctTestableTokens(Object object) {
        return this.testIndex.getPossibleMatches(object);
    }

    public int getNumberOfTokens() {
        return this.freeTokens.getSize();
    }

    public int getNumberOfTestedTokens() {
        return this.testedTokens.getUniqueSize();
    }

    public int getNumberOfTestableTokens() {
        return this.getNumberOfTokens() + this.getNumberOfTestedTokens();
    }

    boolean containsToken(Object object) {
        return this.freeTokens.includes(object);
    }

    public int getTokenCount(Object object) {
        return this.freeTokens.getMultiplicity(object);
    }

    public boolean containsTestedToken(Object object) {
        return this.testedTokens.includes(object);
    }

    boolean containsTestableToken(Object object) {
        return this.containsToken(object) || this.containsTestedToken(object);
    }

    void removeToken(Object object) {
        this.freeTokens.removeOneOf(object);
        if (!this.freeTokens.includes(object)) {
            this.freeIndex.remove(object);
            if (!this.testedTokens.includes(object)) {
                this.testIndex.remove(object);
            }
        }
        this.triggerables.proposeSearch(false, true);
        UpdatableSet updatableSet = this.listeners;
        synchronized (updatableSet) {
            TokenEvent tokenEvent = new TokenEvent(this, object);
            CollectionEnumeration collectionEnumeration = this.listeners.elements();
            while (collectionEnumeration.hasMoreElements()) {
                PlaceEventListener placeEventListener = (PlaceEventListener)collectionEnumeration.nextElement();
                placeEventListener.tokenRemoved(tokenEvent);
            }
            return;
        }
    }

    void testToken(Object object) {
        boolean bl = false;
        if (!this.testedTokens.includes(object)) {
            this.freeTokens.removeOneOf(object);
            if (!this.freeTokens.includes(object)) {
                this.freeIndex.remove(object);
            }
            this.triggerables.proposeSearch(false, true);
            bl = true;
        }
        this.testedTokens.add(object);
        if (bl) {
            UpdatableSet updatableSet = this.listeners;
            synchronized (updatableSet) {
                TokenEvent tokenEvent = new TokenEvent(this, object);
                CollectionEnumeration collectionEnumeration = this.listeners.elements();
                while (collectionEnumeration.hasMoreElements()) {
                    PlaceEventListener placeEventListener = (PlaceEventListener)collectionEnumeration.nextElement();
                    placeEventListener.tokenTested(tokenEvent);
                }
                return;
            }
        }
    }

    public void silentlyInsertToken(Object object) {
        if (!this.freeTokens.includes(object)) {
            this.freeIndex.insert(object);
            if (!this.testedTokens.includes(object)) {
                this.testIndex.insert(object);
            }
        }
        this.freeTokens.add(object);
    }

    void insertToken(Object object) {
        this.silentlyInsertToken(object);
        this.triggerables.proposeSearch(true, false);
        UpdatableSet updatableSet = this.listeners;
        synchronized (updatableSet) {
            TokenEvent tokenEvent = new TokenEvent(this, object);
            CollectionEnumeration collectionEnumeration = this.listeners.elements();
            while (collectionEnumeration.hasMoreElements()) {
                PlaceEventListener placeEventListener = (PlaceEventListener)collectionEnumeration.nextElement();
                placeEventListener.tokenAdded(tokenEvent);
            }
            return;
        }
    }

    void untestToken(Object object) {
        this.testedTokens.removeOneOf(object);
        if (!this.testedTokens.includes(object)) {
            if (!this.freeTokens.includes(object)) {
                this.freeIndex.insert(object);
            }
            this.freeTokens.add(object);
            this.triggerables.proposeSearch(true, false);
            UpdatableSet updatableSet = this.listeners;
            synchronized (updatableSet) {
                TokenEvent tokenEvent = new TokenEvent(this, object);
                CollectionEnumeration collectionEnumeration = this.listeners.elements();
                while (collectionEnumeration.hasMoreElements()) {
                    PlaceEventListener placeEventListener = (PlaceEventListener)collectionEnumeration.nextElement();
                    placeEventListener.tokenUntested(tokenEvent);
                }
                return;
            }
        }
    }

    void createConfirmation(Tracer tracer) {
        UpdatableSet updatableSet = this.listeners;
        synchronized (updatableSet) {
            CollectionEnumeration collectionEnumeration = this.initTokens.elements();
            if (collectionEnumeration.hasMoreElements()) {
                Object object;
                do {
                    object = Null.convert(collectionEnumeration.nextElement());
                    if (this.place.getTrace()) {
                        tracer.trace("    Putting " + object + " into " + this);
                    }
                    this.silentlyInsertToken(object);
                } while (collectionEnumeration.hasMoreElements());
                this.triggerables.proposeSearch(true, false);
                object = new PlaceEvent(this);
                CollectionEnumeration collectionEnumeration2 = this.listeners.elements();
                while (collectionEnumeration2.hasMoreElements()) {
                    PlaceEventListener placeEventListener = (PlaceEventListener)collectionEnumeration2.nextElement();
                    placeEventListener.markingChanged((PlaceEvent)object);
                }
            }
            this.initTokens = null;
            return;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.delayedWriteObject(this.freeTokens, this);
            renewObjectOutputStream.delayedWriteObject(this.testedTokens, this);
            renewObjectOutputStream.delayedWriteObject(this.triggerables, this);
            renewObjectOutputStream.endDomain(this);
            return;
        }
        objectOutputStream.writeObject(this.freeTokens);
        objectOutputStream.writeObject(this.testedTokens);
        objectOutputStream.writeObject(this.triggerables);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lockOrder = Orderer.getTicket();
        this.lock = new Lock();
        this.listeners = new HashedSet();
        if (objectInputStream instanceof RenewObjectInputStream) {
            this.bagCounter = 1;
            return;
        }
        this.freeTokens = (TokenBag)objectInputStream.readObject();
        this.testedTokens = (TokenBag)objectInputStream.readObject();
        this.triggerables = (TriggerableCollection)objectInputStream.readObject();
        this.recomputeIndexes();
    }

    public void reassignField(Object object) throws IOException {
        if (object instanceof TokenBag) {
            TokenBag tokenBag = (TokenBag)object;
            switch (this.bagCounter) {
                case 1: {
                    ++this.bagCounter;
                    this.freeTokens = tokenBag;
                    return;
                }
                case 2: {
                    this.bagCounter = -1;
                    this.testedTokens = tokenBag;
                    this.recomputeIndexes();
                    return;
                }
            }
            throw new NotSerializableException("Too many TokenBags or TokenBag unexpectedly given to reassign().");
        }
        if (object instanceof TriggerableCollection) {
            this.triggerables = (TriggerableCollection)object;
            return;
        }
        throw new NotSerializableException("Value of unexpected type given to reassign().");
    }

    private void recomputeIndexes() {
        this.freeIndex = new TupleIndex();
        this.addToIndex(this.freeIndex, this.freeTokens);
        this.testIndex = new TupleIndex();
        this.addToIndex(this.testIndex, this.freeTokens);
        this.addToIndex(this.testIndex, this.testedTokens);
    }

    private void addToIndex(TupleIndex tupleIndex, TokenBag tokenBag) {
        CollectionEnumeration collectionEnumeration = tokenBag.uniqueElements();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            tupleIndex.insert(e);
        }
    }
}

