/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.simulator.SearchQueueData;
import de.renew.simulator.Searchable;
import de.renew.util.EmptyEnumeration;

class RandomSearchQueue
implements SearchQueueData {
    private Searchable[] elements;
    private int size;
    private UpdatableSet isUnchecked;

    RandomSearchQueue() {
        this.init(new EmptyEnumeration());
    }

    private void setCapacity(int n) {
        Searchable[] searchableArray = new Searchable[n];
        System.arraycopy(this.elements, 0, searchableArray, 0, this.size);
        this.elements = searchableArray;
    }

    private void ensureCapacity(int n) {
        if (n > this.elements.length) {
            if (n < 2 * this.elements.length) {
                n = 2 * this.elements.length;
            }
            this.setCapacity(n);
        }
    }

    private void limitCapacity() {
        if (this.size >= 8 && this.size * 4 < this.elements.length) {
            this.setCapacity(this.size * 2);
        }
    }

    public void include(Searchable searchable) {
        if (!this.isUnchecked.includes(searchable)) {
            this.ensureCapacity(this.size + 1);
            this.elements[this.size++] = searchable;
            this.isUnchecked.include(searchable);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Searchable extract() {
        if (this.isEmpty()) {
            return null;
        }
        int n = (int)(Math.random() * (double)this.size);
        if (n >= this.size) {
            n = this.size - 1;
        }
        Searchable searchable = this.elements[n];
        this.elements[n] = this.elements[this.size - 1];
        this.elements[this.size - 1] = null;
        --this.size;
        this.limitCapacity();
        this.isUnchecked.exclude(searchable);
        return searchable;
    }

    public CollectionEnumeration elements() {
        return this.isUnchecked.elements();
    }

    public int size() {
        return this.size;
    }

    public void init(CollectionEnumeration collectionEnumeration) {
        this.elements = new Searchable[8];
        this.size = 0;
        this.isUnchecked = new HashedSet();
        while (collectionEnumeration.hasMoreElements()) {
            Searchable searchable = (Searchable)collectionEnumeration.nextElement();
            this.include(searchable);
            this.isUnchecked.include(searchable);
        }
    }
}

