/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.LinkedList;
import collections.UpdatableSeq;
import de.renew.simulator.RandomSearchQueue;
import de.renew.simulator.SearchQueueData;
import de.renew.simulator.SearchQueueListener;
import de.renew.simulator.Searchable;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;

public abstract class SearchQueue {
    private static SearchQueueData instance = new RandomSearchQueue();
    private static UpdatableSeq listeners = new LinkedList();
    static /* synthetic */ Class class$de$renew$simulator$SearchQueue;

    public static synchronized void setQueue(SearchQueueData searchQueueData) {
        searchQueueData.init(instance.elements());
        instance = searchQueueData;
    }

    public static synchronized void reset() {
        try {
            instance = (SearchQueueData)instance.getClass().newInstance();
            return;
        }
        catch (Exception exception) {
            instance = new RandomSearchQueue();
            return;
        }
    }

    public static synchronized void insertListener(SearchQueueListener searchQueueListener) {
        listeners.insertFirst(searchQueueListener);
    }

    protected static synchronized void notifyListeners() {
        CollectionEnumeration collectionEnumeration = listeners.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ((SearchQueueListener)collectionEnumeration.nextElement()).searchQueueNonempty();
        }
        listeners.clear();
    }

    public static synchronized void include(Searchable searchable) {
        searchable.triggers().clear();
        instance.include(searchable);
        SearchQueue.notifyListeners();
    }

    public static synchronized boolean isEmpty() {
        return instance.isEmpty();
    }

    public static synchronized Searchable extract() {
        return instance.extract();
    }

    public static synchronized void saveQueue(ObjectOutput objectOutput) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutput instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutput;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(class$de$renew$simulator$SearchQueue != null ? class$de$renew$simulator$SearchQueue : (class$de$renew$simulator$SearchQueue = SearchQueue.class$("de.renew.simulator.SearchQueue")));
        }
        objectOutput.writeInt(instance.size());
        CollectionEnumeration collectionEnumeration = instance.elements();
        while (collectionEnumeration.hasMoreElements()) {
            objectOutput.writeObject(collectionEnumeration.nextElement());
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.writeDelayedObjects();
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain(class$de$renew$simulator$SearchQueue != null ? class$de$renew$simulator$SearchQueue : (class$de$renew$simulator$SearchQueue = SearchQueue.class$("de.renew.simulator.SearchQueue")));
        }
    }

    public static synchronized void loadQueue(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2 = objectInput.readInt();
        Searchable[] searchableArray = new Searchable[n2];
        try {
            n = 0;
            while (n < n2) {
                searchableArray[n] = (Searchable)ClassSource.readObject(objectInput);
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("Object other than Searchable found when looking for SearchQueue elements: " + classCastException.getMessage());
        }
        if (objectInput instanceof RenewObjectInputStream) {
            ((RenewObjectInputStream)objectInput).readDelayedObjects();
        }
        n = 0;
        while (n < n2) {
            SearchQueue.include(searchableArray[n]);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

