/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.LinkedList;
import collections.UpdatableSet;
import de.renew.simulator.Binder;
import de.renew.simulator.ChannelBinder;
import de.renew.simulator.ChannelTarget;
import de.renew.simulator.Finder;
import de.renew.simulator.Occurrence;
import de.renew.simulator.SearchQueue;
import de.renew.simulator.Searchable;
import de.renew.simulator.TokenReserver;
import de.renew.simulator.Triggerable;
import de.renew.simulator.TriggerableCollection;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Copier;
import de.renew.unify.StateRecorder;
import de.renew.unify.Variable;
import java.util.Enumeration;

public class Searcher {
    private boolean bindingPossible;
    private Finder finder;
    private UpdatableSet binders = new HashedSet();
    private UpdatableSet occurrences = new HashedSet();
    private Triggerable primaryTriggerable;
    public CalculationChecker calcChecker = new CalculationChecker();
    public StateRecorder recorder = new StateRecorder();
    public TokenReserver reserver = new TokenReserver();

    public boolean isCompleted() {
        boolean bl = this.finder.isCompleted();
        if (bl) {
            this.bindingPossible = true;
        }
        return bl;
    }

    private void setPrimaryTriggerable(Triggerable triggerable) {
        if (triggerable != null) {
            triggerable.triggers().clear();
        }
        this.primaryTriggerable = triggerable;
    }

    public void insertTriggerable(TriggerableCollection triggerableCollection) {
        if (this.primaryTriggerable != null) {
            triggerableCollection.include(this.primaryTriggerable);
        }
    }

    public void addOccurrence(Occurrence occurrence) {
        this.occurrences.include(occurrence);
    }

    public void removeOccurrence(Occurrence occurrence) {
        this.occurrences.exclude(occurrence);
    }

    public CollectionEnumeration getOccurrences() {
        return this.occurrences.elements();
    }

    public CollectionEnumeration makeExecutables() {
        LinkedList linkedList = new LinkedList();
        Copier copier = new Copier();
        CollectionEnumeration collectionEnumeration = this.getOccurrences();
        while (collectionEnumeration.hasMoreElements()) {
            Occurrence occurrence = (Occurrence)collectionEnumeration.nextElement();
            linkedList.prependElements(occurrence.makeExecutables(copier));
        }
        return linkedList.elements();
    }

    private Binder selectBestBinder() {
        Binder binder = null;
        int n = 10000;
        CollectionEnumeration collectionEnumeration = this.binders.elements();
        while (collectionEnumeration.hasMoreElements() && !this.isCompleted()) {
            Binder binder2 = (Binder)collectionEnumeration.nextElement();
            int n2 = binder2.bindingBadness(this);
            if (n2 >= n) continue;
            binder = binder2;
            n = n2;
        }
        return binder;
    }

    public void search() {
        if (!this.binders.isEmpty()) {
            Binder binder = this.selectBestBinder();
            if (binder != null && !this.isCompleted()) {
                int n = this.recorder.checkpoint();
                this.removeBinder(binder);
                binder.bind(this);
                this.addBinder(binder);
                this.recorder.restore(n);
                return;
            }
        } else if (this.calcChecker.isConsistent()) {
            this.bindingPossible = true;
            this.finder.found(this);
        }
    }

    public void addBinder(Binder binder) {
        this.binders.include(binder);
    }

    public void removeBinder(Binder binder) {
        this.binders.exclude(binder);
    }

    public void addBinders(Enumeration enumeration) {
        this.binders.includeElements(enumeration);
    }

    public void removeBinders(Enumeration enumeration) {
        this.binders.removeElements(enumeration);
    }

    private void startSearch() {
        this.recorder.restore();
        if (!this.occurrences.isEmpty() || !this.binders.isEmpty()) {
            throw new RuntimeException("Searcher was not in idle state at the start of a search.");
        }
    }

    private void searchAndRecover(Searchable searchable, Triggerable triggerable) {
        this.setPrimaryTriggerable(triggerable);
        try {
            searchable.startSearch(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.binders.clear();
        this.occurrences.clear();
        this.calcChecker.reset();
        this.recorder.restore();
        this.reserver.reset();
        this.setPrimaryTriggerable(null);
    }

    public void searchLoop(Finder finder) {
        Object object;
        this.startSearch();
        this.finder = finder;
        LinkedList linkedList = new LinkedList();
        while (!this.isCompleted() && !SearchQueue.isEmpty()) {
            this.bindingPossible = false;
            object = SearchQueue.extract();
            this.searchAndRecover((Searchable)object, (Triggerable)object);
            if (!this.bindingPossible) continue;
            linkedList.insertFirst(object);
        }
        object = linkedList.elements();
        while (object.hasMoreElements()) {
            SearchQueue.include((Searchable)object.nextElement());
        }
        this.finder = null;
    }

    void searchOnce(Finder finder, Searchable searchable, Triggerable triggerable) {
        this.startSearch();
        this.finder = finder;
        this.bindingPossible = false;
        this.searchAndRecover(searchable, triggerable);
        this.finder = null;
    }

    public void initiatedSearch(ChannelTarget channelTarget, String string, Variable variable, boolean bl, Finder finder, Triggerable triggerable) {
        this.startSearch();
        this.finder = finder;
        this.setPrimaryTriggerable(triggerable);
        try {
            Variable variable2 = new Variable(channelTarget, this.recorder);
            ChannelBinder channelBinder = new ChannelBinder(variable2, string, variable, bl);
            this.addBinder(channelBinder);
            this.search();
            this.removeBinder(channelBinder);
            this.recorder.restore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.binders.clear();
        this.occurrences.clear();
        this.calcChecker.reset();
        this.recorder.restore();
        this.reserver.reset();
        this.setPrimaryTriggerable(null);
        finder = null;
    }
}

