/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import de.renew.simulator.ConsoleTracer;
import de.renew.simulator.ConsoleTracerFactory;
import de.renew.simulator.ExecuteFinder;
import de.renew.simulator.Net;
import de.renew.simulator.Searcher;
import de.renew.simulator.Simulator;
import de.renew.simulator.SimulatorHelper;
import de.renew.simulator.Tracer;
import de.renew.simulator.TracerFactory;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class SequentialSimulator
implements Simulator,
Runnable {
    private long cycle = 1L;
    private ExecuteFinder finder;
    private Searcher searcher = new Searcher();
    private boolean stepFired = false;
    private boolean wantBreak = false;
    private Thread runThread;
    private final TracerFactory tracerFactory;

    public static void main(String[] stringArray) {
        Serializable serializable;
        if (stringArray.length == 0) {
            System.out.println("Usage: java de.renew.simulator.SequentialSimulator [CLASS]");
            System.exit(0);
        }
        Net net = null;
        try {
            serializable = Class.forName(stringArray[0]);
            net = (Net)serializable.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(stringArray[0]) + " isn't a valid net class as it seems.");
            if (exception instanceof InvocationTargetException) {
                ((InvocationTargetException)exception).getTargetException().printStackTrace();
            }
            exception.printStackTrace();
            System.exit(1);
        }
        serializable = SimulatorHelper.fireInitially(net, new ConsoleTracer("Initially", "(0) "), true);
        if (serializable != null) {
            SequentialSimulator sequentialSimulator = new SequentialSimulator();
            sequentialSimulator.startRun();
            return;
        }
        System.out.println("The net did not accept the init request.");
    }

    public SequentialSimulator() {
        this.tracerFactory = new ConsoleTracerFactory("");
        this.findNewBinding();
    }

    public SequentialSimulator(TracerFactory tracerFactory) {
        this.tracerFactory = tracerFactory;
        this.findNewBinding();
    }

    public boolean isActive() {
        return this.finder.isCompleted();
    }

    public synchronized void startRun() {
        if (this.runThread == null) {
            this.runThread = new Thread(this);
            this.runThread.setPriority(1);
            this.runThread.start();
        }
    }

    public synchronized void stopRun() {
        while (this.runThread != null) {
            this.wantBreak = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void terminateRun() {
        this.stopRun();
    }

    private void fire(Tracer tracer) {
        this.stepFired = this.finder.isCompleted();
        if (this.stepFired) {
            this.finder.execute(tracer, false);
            this.findNewBinding();
        }
    }

    private void findNewBinding() {
        this.finder = new ExecuteFinder();
        this.searcher.searchLoop(this.finder);
    }

    public synchronized int step() {
        if (this.runThread != null) {
            this.stopRun();
        } else {
            this.fire(this.tracerFactory.getTracer("Synchronously", String.valueOf(this.cycle++)));
        }
        if (this.stepFired) {
            if (this.finder.isCompleted()) {
                return 1;
            }
            return 2;
        }
        return 4;
    }

    public void run() {
        if (!this.finder.isCompleted()) {
            this.findNewBinding();
        }
        while (this.finder.isCompleted() && !this.wantBreak) {
            Thread.yield();
            this.fire(this.tracerFactory.getTracer("Synchronously", String.valueOf(this.cycle++)));
        }
        SequentialSimulator sequentialSimulator = this;
        synchronized (sequentialSimulator) {
            this.runThread = null;
            this.wantBreak = false;
            this.notifyAll();
            return;
        }
    }
}

