/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.LinkedList;
import collections.Seq;
import de.renew.simulator.CollectingFinder;
import de.renew.simulator.EarlyExecutable;
import de.renew.simulator.EnablednessFinder;
import de.renew.simulator.ExecuteFinder;
import de.renew.simulator.LateExecutable;
import de.renew.simulator.LateRunnable;
import de.renew.simulator.LockComparator;
import de.renew.simulator.Net;
import de.renew.simulator.NetInstance;
import de.renew.simulator.PhaseComparator;
import de.renew.simulator.SearchQueue;
import de.renew.simulator.Searchable;
import de.renew.simulator.Searcher;
import de.renew.simulator.Tracer;
import de.renew.simulator.TransitionInstance;
import de.renew.simulator.Triggerable;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.unify.Variable;
import de.renew.util.Detacher;

public class SimulatorHelper {
    public static NetInstance fireInitially(Net net, Tracer tracer, boolean bl) {
        NetInstance netInstance;
        Searcher searcher = new Searcher();
        try {
            netInstance = net.makeInstance();
        }
        catch (Impossible impossible) {
            impossible.printStackTrace();
            netInstance = null;
        }
        ExecuteFinder executeFinder = new ExecuteFinder();
        if (netInstance != null) {
            Variable variable = new Variable(new Tuple(0), null);
            searcher.initiatedSearch(netInstance, "new", variable, true, executeFinder, null);
            if (!executeFinder.isCompleted()) {
                netInstance = null;
            }
        }
        if (netInstance != null) {
            netInstance.createConfirmation(tracer);
            executeFinder.execute(tracer, bl);
        }
        return netInstance;
    }

    public static boolean isFirable(Searchable searchable, Triggerable triggerable, Searcher searcher) {
        EnablednessFinder enablednessFinder = new EnablednessFinder();
        searcher.searchOnce(enablednessFinder, searchable, triggerable);
        return enablednessFinder.isEnabled();
    }

    public static boolean isFirable(Searchable searchable, Triggerable triggerable) {
        Searcher searcher = new Searcher();
        return SimulatorHelper.isFirable(searchable, triggerable, searcher);
    }

    public static boolean fireOneBinding(TransitionInstance transitionInstance, Tracer tracer, boolean bl, Searcher searcher) {
        ExecuteFinder executeFinder = new ExecuteFinder();
        searcher.searchOnce(executeFinder, transitionInstance, transitionInstance);
        if (executeFinder.isCompleted()) {
            SearchQueue.include(transitionInstance);
            executeFinder.execute(tracer, bl);
            return true;
        }
        return false;
    }

    public static boolean fireOneBinding(TransitionInstance transitionInstance, Tracer tracer, boolean bl) {
        Searcher searcher = new Searcher();
        return SimulatorHelper.fireOneBinding(transitionInstance, tracer, bl, searcher);
    }

    public static CollectionEnumeration findAllBindings(Searchable searchable, Triggerable triggerable, Searcher searcher) {
        CollectingFinder collectingFinder = new CollectingFinder();
        searcher.searchOnce(collectingFinder, searchable, triggerable);
        return collectingFinder.bindings();
    }

    public static CollectionEnumeration findAllBindings(Searchable searchable, Triggerable triggerable) {
        Searcher searcher = new Searcher();
        return SimulatorHelper.findAllBindings(searchable, triggerable, searcher);
    }

    private static void lock(Seq seq) {
        CollectionEnumeration collectionEnumeration = seq.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ((EarlyExecutable)collectionEnumeration.nextElement()).lock();
        }
    }

    private static void unlock(Seq seq) {
        CollectionEnumeration collectionEnumeration = seq.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ((EarlyExecutable)collectionEnumeration.nextElement()).unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void verify(Seq var0) throws Impossible {
        var1_1 = new LinkedList();
        try {
            var2_2 = var0.elements();
            while (var2_2.hasMoreElements()) {
                var3_4 = (EarlyExecutable)var2_2.nextElement();
                var3_4.verify();
                var1_1.insertFirst(var3_4);
            }
            return;
        }
        catch (Impossible var2_3) {
            var3_5 = var1_1.elements();
            ** while (var3_5.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            ((EarlyExecutable)var3_5.nextElement()).rollback();
            continue;
        }
lbl15:
        // 1 sources

        throw var2_3;
    }

    private static void executeEarly(Seq seq, Tracer tracer) {
        CollectionEnumeration collectionEnumeration = seq.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ((EarlyExecutable)collectionEnumeration.nextElement()).execute(tracer);
        }
    }

    static void executeLate(Seq seq, Tracer tracer) {
        CollectionEnumeration collectionEnumeration = seq.elements();
        while (collectionEnumeration.hasMoreElements()) {
            LateExecutable lateExecutable = (LateExecutable)collectionEnumeration.nextElement();
            if (lateExecutable.isLong()) {
                Detacher.detach();
            }
            try {
                lateExecutable.execute(tracer);
            }
            catch (Exception exception) {
                tracer.trace("Exception occurred during late phase of firing:");
                tracer.trace(exception.toString());
                exception.printStackTrace();
                tracer.complete();
                return;
            }
        }
        tracer.complete();
    }

    public static boolean execute(CollectionEnumeration collectionEnumeration, Tracer tracer, boolean bl) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            if (e instanceof EarlyExecutable) {
                linkedList.insertFirst(e);
                continue;
            }
            if (e instanceof LateExecutable) {
                linkedList2.insertFirst(e);
                continue;
            }
            throw new RuntimeException("Unknown type of executable detected: " + e);
        }
        linkedList.sort(new LockComparator());
        SimulatorHelper.lock(linkedList);
        try {
            try {
                linkedList.sort(new PhaseComparator());
                SimulatorHelper.verify(linkedList);
                SimulatorHelper.executeEarly(linkedList, tracer);
            }
            finally {
                Object var6_7 = null;
                SimulatorHelper.unlock(linkedList);
            }
            linkedList2.sort(new PhaseComparator());
            if (bl) {
                Detacher.startAttached(new Thread(new LateRunnable(linkedList2, tracer)));
            } else {
                SimulatorHelper.executeLate(linkedList2, tracer);
            }
            return true;
        }
        catch (Impossible impossible) {
            return false;
        }
    }
}

