/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.LinkedList;
import de.renew.simulator.PlaceInstance;
import de.renew.simulator.TokenBag;
import de.renew.util.Null;

class TokenReservation {
    private PlaceInstance instance;
    private int reservations;
    private TokenBag testedTokens;
    private TokenBag removedTokens;

    TokenReservation(PlaceInstance placeInstance) {
        this.instance = placeInstance;
        this.reservations = 0;
        this.testedTokens = new TokenBag();
        this.removedTokens = new TokenBag();
    }

    boolean isRemovable() {
        return this.reservations == 0;
    }

    public boolean containsRemovableToken(Object object) {
        boolean bl;
        this.instance.lock.lock();
        int n = this.removedTokens.getMultiplicity(object) + 1;
        boolean bl2 = bl = this.testedTokens.getMultiplicity(object) > 0;
        if (bl && !this.instance.containsTestedToken(object)) {
            ++n;
        }
        boolean bl3 = this.instance.getTokenCount(object) >= n;
        this.instance.lock.unlock();
        return bl3;
    }

    public boolean containsTestableToken(Object object) {
        this.instance.lock.lock();
        int n = this.removedTokens.getMultiplicity(object);
        if (!this.instance.containsTestedToken(object)) {
            ++n;
        }
        boolean bl = this.instance.getTokenCount(object) >= n;
        this.instance.lock.unlock();
        return bl;
    }

    public boolean removeToken(Object object) {
        this.instance.lock.lock();
        boolean bl = this.containsRemovableToken(object);
        if (bl) {
            this.removedTokens.add(object);
            ++this.reservations;
        }
        this.instance.lock.unlock();
        return bl;
    }

    public boolean testToken(Object object) {
        this.instance.lock.lock();
        boolean bl = this.containsTestableToken(object);
        if (bl) {
            this.testedTokens.add(object);
            ++this.reservations;
        }
        this.instance.lock.unlock();
        return bl;
    }

    public void unremoveToken(Object object) {
        this.removedTokens.removeOneOf(object);
        --this.reservations;
    }

    public void untestToken(Object object) {
        this.testedTokens.removeOneOf(object);
        --this.reservations;
    }

    public CollectionEnumeration getRemovableTokens(Object object) {
        this.instance.lock.lock();
        CollectionEnumeration collectionEnumeration = this.instance.getDistinctTokens(object);
        LinkedList linkedList = new LinkedList();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            if (!this.containsRemovableToken(e)) continue;
            linkedList.insertFirst(Null.convert(e));
        }
        this.instance.lock.unlock();
        return Null.convertEnumeration(linkedList.elements());
    }

    public CollectionEnumeration getTestableTokens(Object object) {
        this.instance.lock.lock();
        CollectionEnumeration collectionEnumeration = this.instance.getDistinctTestableTokens(object);
        LinkedList linkedList = new LinkedList();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            if (!this.containsTestableToken(e)) continue;
            linkedList.insertFirst(Null.convert(e));
        }
        this.instance.lock.unlock();
        return Null.convertEnumeration(linkedList.elements());
    }
}

