/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import de.renew.simulator.PlaceInstance;
import de.renew.simulator.TokenReservation;
import java.util.Hashtable;

class TokenReserver {
    Hashtable reservations = new Hashtable();

    TokenReserver() {
    }

    public void reset() {
        this.reservations = new Hashtable();
    }

    private TokenReservation getReservation(PlaceInstance placeInstance) {
        if (this.reservations.containsKey(placeInstance)) {
            return (TokenReservation)this.reservations.get(placeInstance);
        }
        TokenReservation tokenReservation = new TokenReservation(placeInstance);
        this.reservations.put(placeInstance, tokenReservation);
        return tokenReservation;
    }

    private void disposeReservation(PlaceInstance placeInstance) {
        TokenReservation tokenReservation = (TokenReservation)this.reservations.get(placeInstance);
        if (tokenReservation.isRemovable()) {
            this.reservations.remove(placeInstance);
        }
    }

    public synchronized boolean containsRemovableToken(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        boolean bl = tokenReservation.containsRemovableToken(object);
        this.disposeReservation(placeInstance);
        return bl;
    }

    public synchronized boolean containsTestableToken(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        boolean bl = tokenReservation.containsTestableToken(object);
        this.disposeReservation(placeInstance);
        return bl;
    }

    public synchronized boolean removeToken(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        boolean bl = tokenReservation.removeToken(object);
        this.disposeReservation(placeInstance);
        return bl;
    }

    public synchronized boolean testToken(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        boolean bl = tokenReservation.testToken(object);
        this.disposeReservation(placeInstance);
        return bl;
    }

    public synchronized void unremoveToken(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        tokenReservation.unremoveToken(object);
        this.disposeReservation(placeInstance);
    }

    public synchronized void untestToken(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        tokenReservation.untestToken(object);
        this.disposeReservation(placeInstance);
    }

    public synchronized CollectionEnumeration getRemovableTokens(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        CollectionEnumeration collectionEnumeration = tokenReservation.getRemovableTokens(object);
        this.disposeReservation(placeInstance);
        return collectionEnumeration;
    }

    public synchronized CollectionEnumeration getTestableTokens(PlaceInstance placeInstance, Object object) {
        TokenReservation tokenReservation = this.getReservation(placeInstance);
        CollectionEnumeration collectionEnumeration = tokenReservation.getTestableTokens(object);
        this.disposeReservation(placeInstance);
        return collectionEnumeration;
    }
}

