/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.simulator.Net;
import de.renew.simulator.TransitionInscription;
import de.renew.simulator.UplinkInscription;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Transition
implements Serializable {
    static final long serialVersionUID = -5900289631849657071L;
    private final String name;
    private boolean trace;
    UplinkInscription uplink;
    UpdatableSet inscriptions;
    private int _id;

    public Transition(Net net, String string) {
        this.name = string;
        this.trace = true;
        this.uplink = null;
        this.inscriptions = new HashedSet();
        net.add(this);
    }

    public String toString() {
        return this.name;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public boolean isSpontaneous() {
        return this.uplink == null;
    }

    private void checkUplink() {
        this.uplink = null;
        CollectionEnumeration collectionEnumeration = this.inscriptions.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Object e = collectionEnumeration.nextElement();
            if (!(e instanceof UplinkInscription)) continue;
            this.uplink = (UplinkInscription)e;
        }
    }

    public void add(TransitionInscription transitionInscription) {
        if (!this.inscriptions.includes(transitionInscription)) {
            this.inscriptions.include(transitionInscription);
            this.checkUplink();
        }
    }

    public void remove(TransitionInscription transitionInscription) {
        if (this.inscriptions.includes(transitionInscription)) {
            this.inscriptions.exclude(transitionInscription);
            this.checkUplink();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain(this);
        }
    }

    public void setID(int n) {
        this._id = n;
    }

    public int getID() {
        return this._id;
    }
}

