/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.event.FiringEvent;
import de.renew.event.TransitionEventListener;
import de.renew.event.TransitionEventProducer;
import de.renew.simulator.NetInstance;
import de.renew.simulator.SearchQueue;
import de.renew.simulator.Searchable;
import de.renew.simulator.Searcher;
import de.renew.simulator.Transition;
import de.renew.simulator.TransitionOccurrence;
import de.renew.simulator.TriggerCollection;
import de.renew.simulator.Triggerable;
import de.renew.simulator.UplinkProvider;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TransitionInstance
implements Searchable,
Triggerable,
UplinkProvider,
TransitionEventProducer,
Serializable,
DelayedFieldOwner {
    static final long serialVersionUID = -2146903280470015837L;
    NetInstance netInstance;
    Transition transition;
    private transient TriggerCollection triggers = new TriggerCollection(this);
    private transient UpdatableSet pendingEvents = new HashedSet();
    private transient UpdatableSet listeners = new HashedSet();

    TransitionInstance(NetInstance netInstance, Transition transition) {
        this.netInstance = netInstance;
        this.transition = transition;
    }

    public String toString() {
        return String.valueOf(this.netInstance.toString()) + "." + this.transition.toString();
    }

    public NetInstance getNetInstance() {
        return this.netInstance;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public TriggerCollection triggers() {
        return this.triggers;
    }

    public synchronized void addTransitionEventListener(TransitionEventListener transitionEventListener) {
        this.listeners.include(transitionEventListener);
    }

    public synchronized void removeTransitionEventListener(TransitionEventListener transitionEventListener) {
        this.listeners.exclude(transitionEventListener);
    }

    public synchronized void proposeSearch(boolean bl, boolean bl2) {
        if (this.transition.isSpontaneous()) {
            SearchQueue.include(this);
        }
    }

    synchronized void firingStarted(FiringEvent firingEvent) {
        this.pendingEvents.include(firingEvent);
        CollectionEnumeration collectionEnumeration = this.listeners.elements();
        while (collectionEnumeration.hasMoreElements()) {
            TransitionEventListener transitionEventListener = (TransitionEventListener)collectionEnumeration.nextElement();
            transitionEventListener.firingStarted(firingEvent);
        }
    }

    synchronized void firingComplete(FiringEvent firingEvent) {
        this.pendingEvents.exclude(firingEvent);
        CollectionEnumeration collectionEnumeration = this.listeners.elements();
        while (collectionEnumeration.hasMoreElements()) {
            TransitionEventListener transitionEventListener = (TransitionEventListener)collectionEnumeration.nextElement();
            transitionEventListener.firingComplete(firingEvent);
        }
    }

    public CollectionEnumeration pendingFiringEvents() {
        return this.pendingEvents.elements();
    }

    void createConfirmation() {
        if (this.transition.isSpontaneous()) {
            SearchQueue.include(this);
        }
    }

    public boolean listensToChannel(String string) {
        return !this.transition.isSpontaneous() && this.transition.uplink.name.equals(string);
    }

    private void createAndSearchOccurrence(Variable variable, Searcher searcher) {
        int n = searcher.recorder.checkpoint();
        try {
            TransitionOccurrence transitionOccurrence = new TransitionOccurrence(this, variable, searcher);
            searcher.addOccurrence(transitionOccurrence);
            searcher.addBinders(transitionOccurrence.getBinders());
            searcher.search();
            searcher.removeBinders(transitionOccurrence.getBinders());
            searcher.removeOccurrence(transitionOccurrence);
        }
        catch (Impossible impossible) {}
        searcher.recorder.restore(n);
    }

    public void bindChannel(Variable variable, Searcher searcher) {
        this.createAndSearchOccurrence(variable, searcher);
    }

    public void startSearch(Searcher searcher) {
        this.createAndSearchOccurrence(null, searcher);
        searcher.recorder.restore();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain(this);
        }
        if (this.pendingEvents.isEmpty()) {
            objectOutputStream.defaultWriteObject();
            if (renewObjectOutputStream != null) {
                renewObjectOutputStream.delayedWriteObject(this.triggers, this);
            } else {
                objectOutputStream.writeObject(this.triggers);
            }
        } else {
            throw new NotSerializableException("Active bindings  at transition instance " + this);
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.endDomain(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pendingEvents = new HashedSet();
        this.listeners = new HashedSet();
        if (!(objectInputStream instanceof RenewObjectInputStream)) {
            this.triggers = (TriggerCollection)objectInputStream.readObject();
        }
    }

    public void reassignField(Object object) throws IOException {
        if (object instanceof TriggerCollection) {
            this.triggers = (TriggerCollection)object;
            return;
        }
        throw new NotSerializableException("Value of unexpected type given to reassign().");
    }
}

