/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator;

import collections.CollectionEnumeration;
import collections.LinkedList;
import collections.UpdatableSeq;
import de.renew.event.FiringEvent;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableMapper;
import de.renew.simulator.FiringCompleteExecutable;
import de.renew.simulator.FiringStartExecutable;
import de.renew.simulator.InscriptionOccurrence;
import de.renew.simulator.Occurrence;
import de.renew.simulator.Searcher;
import de.renew.simulator.TraceExecutable;
import de.renew.simulator.Transition;
import de.renew.simulator.TransitionInscription;
import de.renew.simulator.TransitionInstance;
import de.renew.unify.Copier;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.Enumeration;

public class TransitionOccurrence
implements Occurrence {
    TransitionInstance transitionInstance;
    VariableMapper mapper;
    private UpdatableSeq inscriptionOccurrences;
    private UpdatableSeq binders;

    TransitionOccurrence(TransitionInstance transitionInstance, Variable variable, Searcher searcher) throws Impossible {
        int n = searcher.recorder.checkpoint();
        try {
            Object object;
            this.transitionInstance = transitionInstance;
            this.mapper = new VariableMapper();
            Variable variable2 = this.mapper.map(new LocalVariable("this"));
            try {
                Unify.unify(variable2, transitionInstance.netInstance, null);
            }
            catch (Impossible impossible) {
                throw new RuntimeException("Unification failed unexpectedly.");
            }
            Transition transition = transitionInstance.transition;
            if (!transition.isSpontaneous()) {
                object = transition.uplink.params.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker);
                Unify.unify(object, variable, searcher.recorder);
            }
            this.inscriptionOccurrences = new LinkedList();
            object = transition.inscriptions.elements();
            while (object.hasMoreElements()) {
                TransitionInscription transitionInscription = (TransitionInscription)object.nextElement();
                this.inscriptionOccurrences.prependElements(transitionInscription.makeOccurrences(this.mapper, transitionInstance.netInstance, searcher));
            }
            this.binders = new LinkedList();
            object = this.inscriptionOccurrences.elements();
            while (object.hasMoreElements()) {
                this.binders.prependElements(((InscriptionOccurrence)object.nextElement()).makeBinders(searcher));
            }
            return;
        }
        catch (Impossible impossible) {
            searcher.recorder.restore(n);
            throw impossible;
        }
    }

    CollectionEnumeration getBinders() {
        return this.binders.elements();
    }

    public VariableMapper getMapper() {
        return this.mapper;
    }

    public TransitionInstance getTransitionInstance() {
        return this.transitionInstance;
    }

    public CollectionEnumeration makeExecutables(Copier copier) {
        Object object;
        VariableMapper variableMapper = this.mapper.makeCopy(copier);
        LinkedList linkedList = new LinkedList();
        if (this.transitionInstance.transition.getTrace()) {
            linkedList.insertFirst(new TraceExecutable("  Firing " + this.transitionInstance));
        }
        CollectionEnumeration collectionEnumeration = this.inscriptionOccurrences.elements();
        while (collectionEnumeration.hasMoreElements()) {
            object = (InscriptionOccurrence)collectionEnumeration.nextElement();
            CollectionEnumeration collectionEnumeration2 = object.makeExecutables(copier, variableMapper);
            linkedList.prependElements(collectionEnumeration2);
        }
        object = new FiringEvent(this.transitionInstance, variableMapper);
        linkedList.insertFirst(new FiringStartExecutable((FiringEvent)object));
        linkedList.insertFirst(new FiringCompleteExecutable((FiringEvent)object));
        return linkedList.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.transitionInstance.toString());
        stringBuffer.append("<");
        Enumeration enumeration = this.mapper.getLocalVariables();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            Variable variable;
            LocalVariable localVariable = (LocalVariable)enumeration.nextElement();
            if (localVariable.name.equals("this") || !(variable = this.mapper.map(localVariable)).isBound()) continue;
            if (!bl) {
                stringBuffer.append(",");
            }
            bl = false;
            stringBuffer.append(localVariable.name);
            stringBuffer.append("=");
            stringBuffer.append(variable.getValue());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

