/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import collections.UpdatableSet;
import de.renew.unify.BacklinkSet;
import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.RecorderChecker;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.StateRestorer;
import de.renew.unify.Unifiable;
import de.renew.unify.Unify;
import de.renew.unify.Unknown;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

abstract class Aggregate
implements Unifiable,
Referable,
Referer,
Serializable {
    private BacklinkSet backlinkSet;
    final transient RecorderChecker recorderChecker;
    final Reference[] references;
    private boolean complete;
    private boolean bound;

    Aggregate(int n) {
        this.recorderChecker = new RecorderChecker(null);
        this.references = Unify.makeUnknownReferenceArray(n, this);
        this.complete = n == 0;
        boolean bl = this.bound = n == 0;
        if (!this.complete) {
            this.backlinkSet = new BacklinkSet();
        }
    }

    Aggregate(Object[] objectArray, StateRecorder stateRecorder) {
        this.recorderChecker = new RecorderChecker(stateRecorder);
        this.references = Unify.cleanupReferenceArray(objectArray, this, stateRecorder);
        this.complete = this.calculateComplete();
        this.bound = this.calculateBound();
        if (!this.complete) {
            this.backlinkSet = new BacklinkSet();
        }
    }

    public Object[] asArray(Class clazz) {
        return this.copyInto((Object[])Array.newInstance(clazz, this.references.length));
    }

    public Object[] asArray() {
        return this.copyInto(new Object[this.references.length]);
    }

    public Object[] copyInto(Object[] objectArray) {
        int n = 0;
        while (n < this.references.length) {
            objectArray[n] = this.references[n].value;
            ++n;
        }
        return objectArray;
    }

    private boolean calculateComplete() {
        int n = 0;
        while (n < this.references.length) {
            if (!this.references[n].complete) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean calculateBound() {
        int n = 0;
        while (n < this.references.length) {
            if (!this.references[n].bound) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void possiblyCompleted(UpdatableSet updatableSet, StateRecorder stateRecorder) throws Impossible {
        if (this.references.length == 0) {
            throw new RuntimeException("An empty aggregate became completed.");
        }
        if (!this.complete && this.calculateComplete()) {
            if (stateRecorder != null) {
                stateRecorder.record(new 1());
            }
            this.complete = true;
            if (this.calculateBound()) {
                if (stateRecorder != null) {
                    stateRecorder.record(new 2());
                }
                this.bound = true;
            }
            this.checkBacklinkSet();
            this.backlinkSet.updateBacklinked(this, this, updatableSet, stateRecorder);
            BacklinkSet backlinkSet = this.backlinkSet;
            if (stateRecorder != null) {
                stateRecorder.record(new 3(backlinkSet, this));
            }
            this.backlinkSet = null;
        }
    }

    private void checkBacklinkSet() {
        if (this.backlinkSet == null) {
            if (!this.complete) {
                throw new RuntimeException("A complete object received a backlink. Strange");
            }
            throw new RuntimeException("An incomplete object lacks a backlink set. Strange");
        }
    }

    public void addBacklink(Reference reference, StateRecorder stateRecorder) {
        this.recorderChecker.checkRecorder(stateRecorder);
        this.checkBacklinkSet();
        this.backlinkSet.addBacklink(reference, stateRecorder);
    }

    void unifySilently(Aggregate aggregate, StateRecorder stateRecorder, UpdatableSet updatableSet) throws Impossible {
        if (aggregate.references.length != this.references.length) {
            throw new Impossible();
        }
        int n = 0;
        while (n < this.references.length) {
            Unify.unifySilently(this.references[n].value, aggregate.references[n].value, stateRecorder, updatableSet);
            ++n;
        }
    }

    public void occursCheck(Unknown unknown, UpdatableSet updatableSet) throws Impossible {
        if (this.complete) {
            return;
        }
        IdentityWrapper identityWrapper = new IdentityWrapper(this);
        if (updatableSet.includes(identityWrapper)) {
            return;
        }
        updatableSet.include(identityWrapper);
        int n = 0;
        while (n < this.references.length) {
            this.references[n].occursCheck(unknown, updatableSet);
            ++n;
        }
    }

    boolean matches(Aggregate aggregate) {
        if (this.references.length != aggregate.references.length) {
            return false;
        }
        int n = 0;
        while (n < this.references.length) {
            if (this.references[n].value == null ? aggregate.references[n].value != null : !this.references[n].value.equals(aggregate.references[n].value)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected int refHash(int n) {
        if (this.references[n].value == null) {
            return 1;
        }
        return this.references[n].value.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isComplete()) {
            objectOutputStream.defaultWriteObject();
            return;
        }
        throw new NotSerializableException("de.renew.unify.Aggregate: " + this + " is not complete.");
    }

    static /* synthetic */ boolean access$0(Aggregate aggregate) {
        return aggregate.complete;
    }

    static /* synthetic */ boolean access$2(Aggregate aggregate) {
        return aggregate.bound;
    }

    static /* synthetic */ BacklinkSet access$4(Aggregate aggregate) {
        return aggregate.backlinkSet;
    }

    private final class 1
    implements StateRestorer {
        public void restore() {
            Aggregate.this.complete = false;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements StateRestorer {
        public void restore() {
            Aggregate.this.bound = false;
        }

        /* synthetic */ 2() {
        }
    }

    private static final class 3
    implements StateRestorer {
        private final /* synthetic */ Aggregate this$0;
        private final /* synthetic */ BacklinkSet val$oldBacklinkSet;

        public void restore() {
            this.this$0.backlinkSet = this.val$oldBacklinkSet;
        }

        /* synthetic */ 3(BacklinkSet backlinkSet, Aggregate aggregate) {
            this.val$oldBacklinkSet = backlinkSet;
            this.this$0 = aggregate;
        }
    }
}

