/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Aggregate;
import de.renew.unify.ComponentBranch;
import de.renew.unify.Tuple;
import de.renew.unify.TupleIndexVisitor;
import de.renew.util.HashedRelation;
import java.io.Serializable;

public class ArityBranch
implements Serializable {
    HashedRelation relation = new HashedRelation();
    private ComponentBranch[] branches = new ComponentBranch[0];

    private void setCapacity(int n) {
        ComponentBranch[] componentBranchArray = new ComponentBranch[n];
        System.arraycopy(this.branches, 0, componentBranchArray, 0, Math.min(n, this.branches.length));
        this.branches = componentBranchArray;
    }

    private void ensureCapacity(int n) {
        if (this.branches.length < n) {
            this.setCapacity(n);
        }
    }

    private void trim() {
        int n = this.branches.length;
        while (n > 0 && this.branches[n - 1] == null) {
            --n;
        }
        if (n < this.branches.length) {
            this.setCapacity(n);
        }
    }

    void traverse(TupleIndexVisitor tupleIndexVisitor, Object object) {
        if (tupleIndexVisitor.visitIndex(this, object)) {
            int n;
            int n2;
            Aggregate aggregate = null;
            if (object instanceof Aggregate) {
                aggregate = (Aggregate)object;
                n2 = aggregate.references.length;
                if (n2 == 0) {
                    return;
                }
                n = object instanceof Tuple ? n2 : 0;
            } else {
                return;
            }
            this.ensureCapacity(n + 1);
            if (this.branches[n] == null) {
                this.branches[n] = new ComponentBranch(n2);
            }
            this.branches[n].traverse(tupleIndexVisitor, aggregate);
            if (this.branches[n].size == 0) {
                this.branches[n] = null;
                this.trim();
            }
        }
    }
}

