/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import de.renew.unify.StateRecorder;
import de.renew.unify.StateRestorer;
import java.io.Serializable;

class BacklinkSet
implements Serializable {
    private int cnt;
    private Reference[] backlinks = new Reference[6];
    private UpdatableSet externalSet;

    private boolean includes(Reference reference) {
        if (this.externalSet != null) {
            return this.externalSet.includes(new IdentityWrapper(reference));
        }
        switch (this.cnt) {
            case 6: {
                return reference == this.backlinks[0] || reference == this.backlinks[1] || reference == this.backlinks[2] || reference == this.backlinks[3] || reference == this.backlinks[4] || reference == this.backlinks[5];
            }
            case 5: {
                return reference == this.backlinks[0] || reference == this.backlinks[1] || reference == this.backlinks[2] || reference == this.backlinks[3] || reference == this.backlinks[4];
            }
            case 4: {
                return reference == this.backlinks[0] || reference == this.backlinks[1] || reference == this.backlinks[2] || reference == this.backlinks[3];
            }
            case 3: {
                return reference == this.backlinks[0] || reference == this.backlinks[1] || reference == this.backlinks[2];
            }
            case 2: {
                return reference == this.backlinks[0] || reference == this.backlinks[1];
            }
            case 1: {
                return reference == this.backlinks[0];
            }
        }
        return false;
    }

    private void includeNonElement(Reference reference) {
        if (this.externalSet == null && this.cnt == 6) {
            this.externalSet = new HashedSet();
            int n = 0;
            while (n < 6) {
                this.externalSet.include(new IdentityWrapper(this.backlinks[n]));
                ++n;
            }
        }
        if (this.externalSet != null) {
            this.externalSet.include(new IdentityWrapper(reference));
            return;
        }
        this.backlinks[this.cnt++] = reference;
    }

    private void exclude(Reference reference) {
        if (this.externalSet != null) {
            this.externalSet.exclude(new IdentityWrapper(reference));
            return;
        }
        --this.cnt;
        if (this.backlinks[this.cnt] != reference) {
            if (this.backlinks[0] == reference) {
                this.backlinks[0] = this.backlinks[this.cnt];
            } else if (this.backlinks[1] == reference) {
                this.backlinks[1] = this.backlinks[this.cnt];
            } else if (this.backlinks[2] == reference) {
                this.backlinks[2] = this.backlinks[this.cnt];
            } else {
                throw new RuntimeException("Backlink not found. Strange. ");
            }
        }
        this.backlinks[this.cnt] = null;
    }

    int size() {
        if (this.externalSet != null) {
            return this.externalSet.size();
        }
        return this.cnt;
    }

    void addBacklink(Reference reference, StateRecorder stateRecorder) {
        if (!this.includes(reference)) {
            this.includeNonElement(reference);
            if (stateRecorder != null) {
                stateRecorder.record(new 1(reference, this));
            }
        }
    }

    void updateBacklinked(Referable referable, Object object, UpdatableSet updatableSet, StateRecorder stateRecorder) throws Impossible {
        if (this.externalSet != null) {
            CollectionEnumeration collectionEnumeration = this.externalSet.elements();
            while (collectionEnumeration.hasMoreElements()) {
                IdentityWrapper identityWrapper = (IdentityWrapper)collectionEnumeration.nextElement();
                Reference reference = (Reference)identityWrapper.getObject();
                reference.update(referable, object, updatableSet, stateRecorder);
            }
            return;
        }
        int n = 0;
        while (n < this.cnt) {
            this.backlinks[n].update(referable, object, updatableSet, stateRecorder);
            ++n;
        }
    }

    BacklinkSet() {
    }

    private static final class 1
    implements StateRestorer {
        private final /* synthetic */ BacklinkSet this$0;
        private final /* synthetic */ Reference val$reference;

        public void restore() {
            this.this$0.exclude(this.val$reference);
        }

        /* synthetic */ 1(Reference reference, BacklinkSet backlinkSet) {
            this.val$reference = reference;
            this.this$0 = backlinkSet;
        }
    }
}

