/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.renew.unify.Calculator;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.StateRestorer;
import de.renew.unify.Unify;
import de.renew.unify.Variable;

public final class CalculationChecker {
    private UpdatableSet lateVariables = new HashedSet();
    private UpdatableSet earlyVariables = new HashedSet();

    public void reset() {
        this.lateVariables.clear();
        this.earlyVariables.clear();
    }

    public void addEarlyVariable(Variable variable, StateRecorder stateRecorder) throws Impossible {
        if (!this.earlyVariables.includes(variable)) {
            if (stateRecorder != null) {
                stateRecorder.record(new 1(variable));
            }
            this.earlyVariables.include(variable);
        }
    }

    public void addCalculated(Class clazz, Object object, Object object2, StateRecorder stateRecorder) throws Impossible {
        Unify.unify(object, new Calculator(clazz, object2, stateRecorder), stateRecorder);
    }

    public void addLateVariable(Variable variable, StateRecorder stateRecorder) throws Impossible {
        if (!this.lateVariables.includes(variable)) {
            if (stateRecorder != null) {
                stateRecorder.record(new 2(variable));
            }
            this.lateVariables.include(variable);
        }
    }

    private boolean checkLateVariables() {
        CollectionEnumeration collectionEnumeration = this.lateVariables.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Variable variable = (Variable)collectionEnumeration.nextElement();
            if (variable.isComplete()) continue;
            return false;
        }
        return true;
    }

    private boolean checkEarlyVariables() {
        CollectionEnumeration collectionEnumeration = this.earlyVariables.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Variable variable = (Variable)collectionEnumeration.nextElement();
            if (variable.isBound()) continue;
            return false;
        }
        return true;
    }

    public boolean isConsistent() {
        return this.checkLateVariables() && this.checkEarlyVariables();
    }

    private final class 1
    implements StateRestorer {
        private final /* synthetic */ Variable val$var;

        public void restore() {
            CalculationChecker.this.earlyVariables.exclude(this.val$var);
        }

        /* synthetic */ 1(Variable variable) {
            this.val$var = variable;
        }
    }

    private final class 2
    implements StateRestorer {
        private final /* synthetic */ Variable val$var;

        public void restore() {
            CalculationChecker.this.lateVariables.exclude(this.val$var);
        }

        /* synthetic */ 2(Variable variable) {
            this.val$var = variable;
        }
    }
}

