/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import collections.UpdatableSet;
import de.renew.unify.BacklinkSet;
import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.RecorderChecker;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.StateRestorer;
import de.renew.unify.Unifiable;
import de.renew.unify.Unknown;

public final class Calculator
implements Unifiable,
Referable,
Referer {
    private BacklinkSet backlinkSet;
    private final Reference reference;
    private final RecorderChecker recorderChecker;
    private final Class type;

    Calculator(Class clazz, Object object, StateRecorder stateRecorder) {
        this.recorderChecker = new RecorderChecker(stateRecorder);
        this.reference = new Reference(object, this, stateRecorder);
        this.type = clazz;
        if (!this.isComplete()) {
            this.backlinkSet = new BacklinkSet();
        }
    }

    public boolean isComplete() {
        return this.reference.complete;
    }

    public boolean isBound() {
        return false;
    }

    public Class getType() {
        return this.type;
    }

    private void checkBacklinkSet() {
        if (this.backlinkSet == null) {
            if (this.isComplete()) {
                throw new RuntimeException("A complete tuple received a backlink. Strange");
            }
            throw new RuntimeException("An incomplete tuple lacks a backlink set. Strange");
        }
    }

    public void addBacklink(Reference reference, StateRecorder stateRecorder) {
        this.recorderChecker.checkRecorder(stateRecorder);
        this.checkBacklinkSet();
        this.backlinkSet.addBacklink(reference, stateRecorder);
    }

    public void possiblyCompleted(UpdatableSet updatableSet, StateRecorder stateRecorder) throws Impossible {
        if (this.isComplete()) {
            this.checkBacklinkSet();
            this.backlinkSet.updateBacklinked(this, this, updatableSet, stateRecorder);
            BacklinkSet backlinkSet = this.backlinkSet;
            if (stateRecorder != null) {
                stateRecorder.record(new 1(backlinkSet, this));
            }
            this.backlinkSet = null;
        }
    }

    public void occursCheck(Unknown unknown, UpdatableSet updatableSet) throws Impossible {
        if (this.reference.complete) {
            return;
        }
        IdentityWrapper identityWrapper = new IdentityWrapper(this);
        if (updatableSet.includes(identityWrapper)) {
            return;
        }
        updatableSet.include(identityWrapper);
        this.reference.occursCheck(unknown, updatableSet);
    }

    public boolean equal(Object object) {
        throw new RuntimeException("Somebody compared a calculator.");
    }

    public int hashCode() {
        throw new RuntimeException("Somebody took the hash code of a calculator.");
    }

    static /* synthetic */ BacklinkSet access$0(Calculator calculator) {
        return calculator.backlinkSet;
    }

    private static final class 1
    implements StateRestorer {
        private final /* synthetic */ Calculator this$0;
        private final /* synthetic */ BacklinkSet val$oldBacklinkSet;

        public void restore() {
            this.this$0.backlinkSet = this.val$oldBacklinkSet;
        }

        /* synthetic */ 1(BacklinkSet backlinkSet, Calculator calculator) {
            this.val$oldBacklinkSet = backlinkSet;
            this.this$0 = calculator;
        }
    }
}

