/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.ReloadableDeserializer;
import java.io.IOException;
import java.io.ObjectInput;

public class ClassSource {
    private static ClassLoader loader = null;
    private static ReloadableDeserializer deserializer = null;

    private ClassSource() {
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        loader = classLoader;
        try {
            deserializer = (ReloadableDeserializer)ClassSource.classForName("de.renew.util.ReloadableDeserializerImpl").newInstance();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            throw new RuntimeException("Cannot generate deserializer.");
        }
    }

    public static synchronized Class classForName(String string) throws ClassNotFoundException {
        if (loader == null) {
            return Class.forName(string);
        }
        return loader.loadClass(string);
    }

    public static Object readObject(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        if (deserializer == null) {
            return objectInput.readObject();
        }
        return deserializer.readObject(objectInput);
    }
}

