/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import de.renew.util.GraphNode;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;

public class GraphLayout
extends FigureChangeAdapter {
    double REPULSION_STRENGTH = 0.5;
    double REPULSION_LIMIT = 200.0;
    int REPULSION_TYPE;
    double SPRING_STRENGTH = 0.1;
    double TORQUE_STRENGTH = 0.25;
    double FRICTION_FACTOR = 0.75;
    private Hashtable nodes = new Hashtable();
    private Hashtable edges = new Hashtable();
    private Figure drawing;

    public GraphLayout(Figure figure) {
        this.drawing = figure;
    }

    private GraphNode getGraphNode(Figure figure) {
        return (GraphNode)this.nodes.get(figure);
    }

    private double len(Figure figure) {
        return (Double)this.edges.get(figure);
    }

    public void addNode(Figure figure) {
        this.nodes.put(figure, new GraphNode(figure));
        figure.addFigureChangeListener(this);
    }

    public void addEdge(ConnectionFigure connectionFigure, int n) {
        Dimension dimension = connectionFigure.start().owner().size();
        Dimension dimension2 = connectionFigure.end().owner().size();
        int n2 = Math.max(dimension.width, dimension.height) / 2 + Math.max(dimension2.width, dimension2.height) / 2 + n;
        this.edges.put(connectionFigure, new Double(n2));
    }

    public synchronized void relax() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.nodes == null) {
            return;
        }
        Enumeration enumeration = this.edges.keys();
        while (enumeration.hasMoreElements()) {
            object4 = (ConnectionFigure)enumeration.nextElement();
            double d = this.len((Figure)object4);
            object3 = this.getGraphNode(object4.start().owner());
            object2 = this.getGraphNode(object4.end().owner());
            double d2 = ((GraphNode)object2).x - ((GraphNode)object3).x;
            double d3 = ((GraphNode)object2).y - ((GraphNode)object3).y;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            if (!(d4 > 0.0)) continue;
            double d5 = this.SPRING_STRENGTH * (d - d4) / d4;
            double d6 = d5 * d2;
            double d7 = d5 * d3;
            double d8 = Math.atan2(d2, d3);
            double d9 = -Math.sin(4.0 * d8);
            ((GraphNode)object2).dx += (d6 += this.TORQUE_STRENGTH * d3 * d9 / d4);
            ((GraphNode)object2).dy += (d7 += -this.TORQUE_STRENGTH * d2 * d9 / d4);
            ((GraphNode)object3).dx += -d6;
            ((GraphNode)object3).dy += -d7;
        }
        object4 = this.nodes.elements();
        while (object4.hasMoreElements()) {
            GraphNode graphNode = (GraphNode)object4.nextElement();
            double d = 0.0;
            double d10 = 0.0;
            object = this.nodes.elements();
            while (object.hasMoreElements()) {
                GraphNode graphNode2 = (GraphNode)object.nextElement();
                if (graphNode == graphNode2) continue;
                double d11 = graphNode.x - graphNode2.x;
                double d12 = graphNode.y - graphNode2.y;
                double d13 = d11 * d11 + d12 * d12;
                double d14 = Math.sqrt(d13);
                if (d14 == 0.0) {
                    d += this.REPULSION_STRENGTH * Math.random();
                    d10 += this.REPULSION_STRENGTH * Math.random();
                    continue;
                }
                if (!(d14 < this.REPULSION_LIMIT)) continue;
                d11 /= this.REPULSION_LIMIT;
                d12 /= this.REPULSION_LIMIT;
                d14 /= this.REPULSION_LIMIT;
                double d15 = 0.0;
                switch (this.REPULSION_TYPE) {
                    case 0: {
                        d15 = 0.5 * (1.0 - d14) / d14;
                        break;
                    }
                    case 1: {
                        d15 = 1.0 - d14;
                        break;
                    }
                    case 2: {
                        d15 = 2.0 * (1.0 - d14) * (1.0 - d14);
                        break;
                    }
                }
                d += (d15 *= this.REPULSION_STRENGTH) * d11;
                d10 += d15 * d12;
            }
            graphNode.dx += d;
            graphNode.dy += d10;
        }
        Rectangle rectangle = this.drawing.displayBox();
        Dimension dimension = new Dimension(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        object3 = this.nodes.keys();
        while (object3.hasMoreElements()) {
            object2 = (Figure)object3.nextElement();
            GraphNode graphNode = this.getGraphNode((Figure)object2);
            if (!Boolean.TRUE.equals(object2.getAttribute("Location"))) {
                graphNode.x += Math.max(-5.0, Math.min(5.0, graphNode.dx));
                graphNode.y += Math.max(-5.0, Math.min(5.0, graphNode.dy));
                object = object2.center();
                object2.moveBy((int)Math.round(graphNode.x) - ((Point)object).x, (int)Math.round(graphNode.y) - ((Point)object).y);
                if (graphNode.x < 0.0) {
                    graphNode.x = 0.0;
                } else if (graphNode.x > (double)dimension.width) {
                    graphNode.x = dimension.width;
                }
                if (graphNode.y < 0.0) {
                    graphNode.y = 0.0;
                } else if (graphNode.y > (double)dimension.height) {
                    graphNode.y = dimension.height;
                }
            }
            graphNode.dx *= this.FRICTION_FACTOR;
            graphNode.dy *= this.FRICTION_FACTOR;
        }
    }

    public synchronized void figureChanged(FigureChangeEvent figureChangeEvent) {
        Figure figure;
        if (this.nodes != null && this.nodes.containsKey(figure = figureChangeEvent.getFigure())) {
            this.getGraphNode(figure).update();
        }
    }

    public void remove() {
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.keys();
            while (enumeration.hasMoreElements()) {
                Figure figure = (Figure)enumeration.nextElement();
                figure.removeFigureChangeListener(this);
            }
            this.nodes = null;
            this.edges = null;
        }
    }
}

