/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Lock
implements Serializable {
    private transient Thread lockingThread = null;
    private transient int lockCount = 0;

    public synchronized void lock() {
        Thread thread = Thread.currentThread();
        while (this.lockingThread != null && this.lockingThread != thread) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lockingThread = thread;
        ++this.lockCount;
    }

    public synchronized void unlock() {
        Thread thread = Thread.currentThread();
        if (thread != this.lockingThread) {
            throw new RuntimeException("Lock/unlock mismatch.");
        }
        --this.lockCount;
        if (this.lockCount == 0) {
            this.lockingThread = null;
        }
        this.notify();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Lock lock = this;
        synchronized (lock) {
            if (this.lockCount != 0 || this.lockingThread != null) {
                throw new NotSerializableException("de.renew.util.Lock: " + this + " is in use.");
            }
            objectOutputStream.defaultWriteObject();
            return;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lockCount = 0;
        this.lockingThread = null;
    }
}

