/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.ClassSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionSerializer {
    private ReflectionSerializer() {
    }

    public static void writeField(ObjectOutputStream objectOutputStream, Field field) throws IOException {
        if (field == null) {
            objectOutputStream.writeObject(null);
            return;
        }
        ReflectionSerializer.writeClass(objectOutputStream, field.getDeclaringClass());
        objectOutputStream.writeObject(field.getName());
    }

    public static Field readField(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            Class clazz = ReflectionSerializer.readClass(objectInputStream);
            if (clazz == null) {
                return null;
            }
            String string = (String)objectInputStream.readObject();
            return clazz.getField(string);
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Field: " + classCastException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Field: " + noSuchFieldException);
        }
    }

    public static void writeMethod(ObjectOutputStream objectOutputStream, Method method) throws IOException {
        if (method == null) {
            objectOutputStream.writeObject(null);
            return;
        }
        ReflectionSerializer.writeClass(objectOutputStream, method.getDeclaringClass());
        objectOutputStream.writeObject(method.getName());
        ReflectionSerializer.writeClassArray(objectOutputStream, method.getParameterTypes());
    }

    public static Method readMethod(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            Class clazz = ReflectionSerializer.readClass(objectInputStream);
            if (clazz == null) {
                return null;
            }
            String string = (String)objectInputStream.readObject();
            Class[] classArray = ReflectionSerializer.readClassArray(objectInputStream);
            return clazz.getMethod(string, classArray);
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Method: " + classCastException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflectMethod: " + noSuchMethodException);
        }
    }

    public static void writeConstructor(ObjectOutputStream objectOutputStream, Constructor constructor) throws IOException {
        if (constructor == null) {
            objectOutputStream.writeObject(null);
            return;
        }
        ReflectionSerializer.writeClass(objectOutputStream, constructor.getDeclaringClass());
        ReflectionSerializer.writeClassArray(objectOutputStream, constructor.getParameterTypes());
    }

    public static Constructor readConstructor(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            Class clazz = ReflectionSerializer.readClass(objectInputStream);
            if (clazz == null) {
                return null;
            }
            Class[] classArray = ReflectionSerializer.readClassArray(objectInputStream);
            return clazz.getConstructor(classArray);
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Constructor: " + classCastException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Constructor: " + noSuchMethodException);
        }
    }

    public static void writeClass(ObjectOutputStream objectOutputStream, Class clazz) throws IOException {
        if (clazz == null) {
            objectOutputStream.writeObject(null);
            return;
        }
        objectOutputStream.writeObject(clazz.getName());
    }

    public static Class readClass(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            String string = (String)objectInputStream.readObject();
            if (string == null) {
                return null;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("char")) {
                return Character.TYPE;
            }
            if (string.equals("double")) {
                return Double.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            if (string.equals("void")) {
                return Void.TYPE;
            }
            return ClassSource.classForName(string);
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.Class: " + classCastException);
        }
    }

    public static void writeClassArray(ObjectOutputStream objectOutputStream, Class[] classArray) throws IOException {
        if (classArray == null) {
            objectOutputStream.writeObject(null);
            return;
        }
        objectOutputStream.writeObject(new Integer(classArray.length));
        int n = 0;
        while (n < classArray.length) {
            ReflectionSerializer.writeClass(objectOutputStream, classArray[n]);
            ++n;
        }
    }

    public static Class[] readClassArray(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (object == null) {
            return null;
        }
        if (object instanceof Class[]) {
            return (Class[])object;
        }
        if (object instanceof Integer) {
            int n = (Integer)object;
            Class[] classArray = new Class[n];
            int n2 = 0;
            while (n2 < n) {
                classArray[n2] = ReflectionSerializer.readClass(objectInputStream);
                ++n2;
            }
            return classArray;
        }
        throw new StreamCorruptedException("(RRS) Could not read java.lang.Class[]: Found " + object.getClass().getName() + " instead.");
    }
}

