/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.DelayedField;
import de.renew.util.DelayedFieldOwner;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class RenewObjectOutputStream
extends ObjectOutputStream {
    private Vector delayedObjects;
    protected static final String SECTIONLABEL = "Delayed:";
    private Stack objectTrace = new Stack();

    public RenewObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.delayedObjects = new Vector();
    }

    public void delayedWriteObject(Object object, DelayedFieldOwner delayedFieldOwner) {
        this.delayedObjects.addElement(new DelayedField(object, delayedFieldOwner));
    }

    public void writeDelayedObjects() throws IOException {
        this.beginDomain(SECTIONLABEL);
        super.writeObject(SECTIONLABEL);
        while (!this.delayedObjects.isEmpty()) {
            int n = this.delayedObjects.size();
            Enumeration enumeration = this.delayedObjects.elements();
            this.delayedObjects = new Vector();
            super.writeInt(n);
            while (enumeration.hasMoreElements()) {
                super.writeObject(enumeration.nextElement());
            }
        }
        super.writeInt(0);
        this.endDomain(SECTIONLABEL);
    }

    public void close() throws IOException {
        try {
            try {
                this.writeDelayedObjects();
            }
            catch (IOException iOException) {
                throw new StreamCorruptedException("Exception occured while writing delayed objects on close: " + iOException);
            }
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.close();
            throw throwable;
        }
        super.close();
    }

    public void beginDomain(Object object) {
        this.objectTrace.push(object);
    }

    public void endDomain(Object object) {
        try {
            if (this.objectTrace.peek() == object) {
                this.objectTrace.pop();
                return;
            }
            System.err.println("End domain by wrong owner requested by " + object);
            System.err.println("Top of stack is " + this.objectTrace.peek());
            System.err.println("Owner resides " + this.objectTrace.search(object) + " from top of stack");
            return;
        }
        catch (EmptyStackException emptyStackException) {
            System.err.println("End domain on empty stack requested by " + object);
            return;
        }
    }

    public Stack getDomainTrace() {
        return (Stack)this.objectTrace.clone();
    }
}

