/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SelectiveClassLoader
extends ClassLoader {
    private Hashtable cache = new Hashtable();
    private String[] classSources;
    private boolean[] isZipFile;
    private ZipFile[] zipFiles;
    private String[] classSelectors;
    private boolean[] wantInclusion;
    private boolean wantFallBack = false;
    private boolean mutable = true;

    public SelectiveClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public SelectiveClassLoader(String string) {
        this(string, new String[0]);
    }

    public SelectiveClassLoader(String string, String[] stringArray) {
        this.setClassPath(string);
        this.setSelectors(stringArray);
    }

    public void setClassPath(String string) {
        this.setClassPath(StringUtil.splitPaths(string));
    }

    public synchronized void setClassPath(String[] stringArray) {
        if (!this.mutable) {
            throw new RuntimeException("Class loader already locked.");
        }
        this.classSources = stringArray;
        this.isZipFile = new boolean[this.classSources.length];
        this.zipFiles = new ZipFile[this.classSources.length];
        int n = 0;
        while (n < this.classSources.length) {
            String string = StringUtil.getExtension(this.classSources[n]);
            boolean bl = this.isZipFile[n] = "jar".equals(string) || "zip".equals(string);
            if (this.isZipFile[n]) {
                try {
                    this.zipFiles[n] = new ZipFile(this.classSources[n]);
                }
                catch (IOException iOException) {
                    this.zipFiles[n] = null;
                }
            } else if (!this.classSources[n].endsWith(File.separator)) {
                this.classSources[n] = String.valueOf(this.classSources[n]) + File.separator;
            }
            System.out.println("SelectiveClassLoader class source: " + this.classSources[n]);
            ++n;
        }
    }

    public void setSelectors(String string) {
        this.setSelectors(StringUtil.splitPaths(string));
    }

    public synchronized void setSelectors(String[] stringArray) {
        if (!this.mutable) {
            throw new RuntimeException("Class loader already locked.");
        }
        this.classSelectors = stringArray;
        this.wantInclusion = new boolean[this.classSelectors.length];
        int n = 0;
        while (n < this.classSelectors.length) {
            boolean bl = this.wantInclusion[n] = !this.classSelectors[n].startsWith("-");
            if (!this.wantInclusion[n]) {
                this.classSelectors[n] = this.classSelectors[n].substring(1);
            }
            ++n;
        }
    }

    public void setFallBack(boolean bl) {
        if (!this.mutable) {
            throw new RuntimeException("Class loader already locked.");
        }
        this.wantFallBack = bl;
    }

    public void lock() {
        this.mutable = false;
    }

    private boolean isSelectedClass(String string) {
        int n = this.classSelectors.length - 1;
        while (n >= 0) {
            if (string.startsWith(this.classSelectors[n])) {
                return this.wantInclusion[n];
            }
            --n;
        }
        return true;
    }

    private byte[] tryLoadZipFile(ZipFile zipFile, String string) throws Exception {
        string = String.valueOf(string.replace('.', '/')) + ".class";
        ZipEntry zipEntry = zipFile.getEntry(string);
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        inputStream.read(byArray);
        inputStream.close();
        return byArray;
    }

    private byte[] tryLoadNormFile(String string, String string2) throws Exception {
        string2 = String.valueOf(string) + StringUtil.classToFile(string2);
        FileInputStream fileInputStream = new FileInputStream(string2);
        byte[] byArray = new byte[((InputStream)fileInputStream).available()];
        ((InputStream)fileInputStream).read(byArray);
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    private byte[] loadClassData(String string) {
        int n = 0;
        while (n < this.classSources.length) {
            byte[] byArray = null;
            try {
                byArray = this.isZipFile[n] ? this.tryLoadZipFile(this.zipFiles[n], string) : this.tryLoadNormFile(this.classSources[n], string);
            }
            catch (Exception exception) {}
            if (byArray != null) {
                return byArray;
            }
            ++n;
        }
        return null;
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.cache.get(string);
        if (clazz == null) {
            if (this.isSelectedClass(string)) {
                try {
                    byte[] byArray = this.loadClassData(string);
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                }
                catch (Exception exception) {
                    if (this.wantFallBack) {
                        clazz = this.findSystemClass(string);
                    }
                    throw new ClassNotFoundException(string);
                }
                catch (ClassFormatError classFormatError) {
                    throw new ClassNotFoundException(string);
                }
            } else {
                clazz = this.findSystemClass(string);
            }
            this.cache.put(string, clazz);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

