/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.TextToken;
import de.renew.util.Types;
import java.io.Serializable;

public final class Value
implements TextToken,
Serializable {
    public final Object value;

    public Value(Object object) {
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Character || object instanceof Boolean) {
            this.value = object;
            return;
        }
        if (object instanceof Value) {
            throw new RuntimeException("Tried to make a nested value. Strange.");
        }
        throw new RuntimeException("Tried to make an object value. Strange.");
    }

    public int hashCode() {
        return this.value.hashCode() + 517293561;
    }

    public boolean equals(Object object) {
        if (object instanceof Value) {
            return this.value.equals(((Value)object).value);
        }
        return false;
    }

    public boolean booleanValue() {
        return (Boolean)this.value;
    }

    public char charValue() {
        return ((Character)this.value).charValue();
    }

    public byte byteValue() {
        return ((Number)this.value).byteValue();
    }

    public short shortValue() {
        return ((Number)this.value).shortValue();
    }

    public int intValue() {
        return ((Number)this.value).intValue();
    }

    public long longValue() {
        return ((Number)this.value).longValue();
    }

    public float floatValue() {
        return ((Number)this.value).floatValue();
    }

    public double doubleValue() {
        return ((Number)this.value).doubleValue();
    }

    public String toTokenText() {
        return this.value.toString();
    }

    public String toString() {
        return String.valueOf(Types.typify(this.value.getClass())) + "(" + this.value.toString() + ")";
    }

    public static Object possiblyWrap(Object object, boolean bl) {
        if (bl) {
            object = new Value(object);
        }
        return object;
    }

    public static Object convertPrimitive(Object object, Class clazz) {
        if (object instanceof Character) {
            if (clazz == Character.TYPE) {
                return object;
            }
            object = new Integer(((Character)object).charValue());
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (clazz == Double.TYPE) {
                return new Double(number.doubleValue());
            }
            if (number instanceof Double) {
                throw new IllegalArgumentException();
            }
            if (clazz == Float.TYPE) {
                return new Float(number.floatValue());
            }
            if (number instanceof Float) {
                throw new IllegalArgumentException();
            }
            if (clazz == Long.TYPE) {
                return new Long(number.longValue());
            }
            if (number instanceof Long) {
                throw new IllegalArgumentException();
            }
            if (clazz == Integer.TYPE) {
                return new Integer(number.intValue());
            }
            if (number instanceof Integer) {
                throw new IllegalArgumentException();
            }
            if (clazz == Short.TYPE) {
                return new Short(number.shortValue());
            }
            if (number instanceof Short) {
                throw new IllegalArgumentException();
            }
            if (clazz == Byte.TYPE) {
                return new Byte(number.byteValue());
            }
            throw new IllegalArgumentException();
        }
        if (object instanceof Boolean) {
            if (clazz == Boolean.TYPE) {
                return object;
            }
            throw new IllegalArgumentException();
        }
        throw new RuntimeException("Encountered a bad value.");
    }

    public Object unvalueAndCast(Class clazz) throws IllegalArgumentException {
        if (clazz.isPrimitive()) {
            return Value.convertPrimitive(this.value, clazz);
        }
        throw new IllegalArgumentException();
    }

    public static Object unvalueAndCast(Object object, Class clazz) throws IllegalArgumentException {
        if (object instanceof Value) {
            return ((Value)object).unvalueAndCast(clazz);
        }
        if (object == null || clazz.isInstance(object)) {
            return object;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] unvalueAndCast(Object[] objectArray, Class[] classArray) throws IllegalArgumentException {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = Value.unvalueAndCast(objectArray[n], classArray[n]);
            ++n;
        }
        return objectArray2;
    }
}

