/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.renew.util.Types;
import de.renew.util.Value;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.JavaObjectFS;
import de.uni_hamburg.fs.SimpleConcept;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.UnificationFailure;

public class Bound
extends SimpleConcept {
    public static final int LOWER = 1;
    public static final int UPPER = -1;
    private Object bound;
    private int type;

    public Bound(int n, Object object) {
        if ((n == -1 || n == 1) && (object instanceof Value || object instanceof String)) {
            this.bound = object;
            this.type = n;
            return;
        }
        System.err.println("Type: " + n + " Class of bound: " + object.getClass());
        throw new RuntimeException("Wrong arguments in constructor of Bound.");
    }

    public boolean subsumesObject(Object object) {
        try {
            return this.compare(this.bound, object) != this.type;
        }
        catch (TypeException typeException) {
            return false;
        }
    }

    public String getName() {
        String string;
        String string2 = string = this.type == 1 ? ">=" : "<=";
        if (this.bound instanceof String) {
            return String.valueOf(string) + '\"' + this.bound.toString() + '\"';
        }
        return String.valueOf(string) + ((Value)this.bound).value.toString();
    }

    public boolean isa(Concept concept) {
        try {
            if (concept instanceof Bound) {
                Bound bound = (Bound)concept;
                return this.type == bound.type && this.compare(this.bound, bound.bound) != this.type;
            }
            if (concept instanceof JavaConcept) {
                Class clazz = ((JavaConcept)concept).getJavaClass();
                if (clazz.isInstance(this.bound)) {
                    return true;
                }
                if (this.bound instanceof Value) {
                    return clazz.equals(Types.typify(((Value)this.bound).value.getClass()));
                }
            }
        }
        catch (TypeException typeException) {}
        return false;
    }

    public boolean isNotA(Concept concept) {
        try {
            if (concept instanceof Bound) {
                Bound bound = (Bound)concept;
                return this.type != bound.type && this.compare(this.bound, bound.bound) == this.type;
            }
        }
        catch (TypeException typeException) {
            return true;
        }
        return !this.isa(concept) && !concept.isa(this);
    }

    public ConceptSet unify(Concept concept) throws UnificationFailure {
        if (concept instanceof Bound) {
            Bound bound = (Bound)concept;
            if (this.type != bound.type && this.bound.equals(bound.bound)) {
                return new ConceptSet(new JavaObjectFS(this.bound));
            }
        }
        return super.unify(concept);
    }

    int compare(Object object, Object object2) throws TypeException {
        if (object instanceof String && object2 instanceof String) {
            return ((String)object).compareTo((String)object2);
        }
        if (object instanceof Value && object2 instanceof Value) {
            Value value = (Value)object;
            Value value2 = (Value)object2;
            Object object3 = value.value;
            Object object4 = value2.value;
            if (!object3.getClass().equals(object4.getClass())) {
                throw new TypeException();
            }
            if (object3.equals(object4)) {
                return 0;
            }
            if (object3 instanceof Boolean) {
                if (value2.booleanValue()) {
                    return -1;
                }
                return 1;
            }
            if (object3 instanceof Character) {
                if (value.charValue() < value2.charValue()) {
                    return -1;
                }
                return 1;
            }
            if (object3 instanceof Byte) {
                if (value.byteValue() < value2.byteValue()) {
                    return -1;
                }
                return 1;
            }
            if (object3 instanceof Short) {
                if (value.shortValue() < value2.shortValue()) {
                    return -1;
                }
                return 1;
            }
            if (object3 instanceof Integer) {
                if (value.intValue() < value2.intValue()) {
                    return -1;
                }
                return 1;
            }
            if (object3 instanceof Long) {
                if (value.longValue() < value2.longValue()) {
                    return -1;
                }
                return 1;
            }
            if (object3 instanceof Float) {
                if (value.floatValue() < value2.floatValue()) {
                    return -1;
                }
                return 1;
            }
            if (object3 instanceof Double) {
                if (value.doubleValue() < value2.doubleValue()) {
                    return -1;
                }
                return 1;
            }
            System.err.println("Wrong bound classes: " + object3.getClass() + " and/or " + object4.getClass());
            throw new TypeException();
        }
        throw new TypeException();
    }
}

